package code.signedVV;

import java.util.Arrays;

public class SignedVVEntry{
  final long timeStamp;
  final byte[] signature;
  
  public SignedVVEntry(long ts, byte[] sig){
    timeStamp = ts;
    signature = sig;
  }

  public byte[] getSingnature(){
    return signature;
  }
  
  public long getTS(){
    return timeStamp;
  }
  
  public boolean equals(Object o){
    if(o instanceof SignedVVEntry){
      SignedVVEntry svve = (SignedVVEntry)o;
      if(timeStamp != svve.getTS() || !Arrays.equals(signature, svve.getSingnature())){
        return false;
      }
      
      return true;
    }else{
      return false;
    }
  }
  
  public SignedVVEntry clone(){
    return new SignedVVEntry(timeStamp, signature);
  }
  
  public int hashCode(){
    return new Long(timeStamp).hashCode();
  }
  
  public String toString(){
    return "(TS: " + timeStamp + ", sizeOfSig: " + signature.length +")";
  }
  
}
