package code.simulator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import code.serialization.IrisInputStream;
import code.serialization.IrisOutputStream;

public abstract class Certificate {
  
  abstract public boolean  verify();
  
  abstract public int getEpoch();
  
  public static Certificate readFromStream(IrisInputStream is, boolean optim) throws IOException{
    int size = is.readInt();
    byte []buf = new byte[size];
    is.readFully(buf);
    ByteArrayInputStream bs  = new ByteArrayInputStream(buf);
    ObjectInputStream ois = new ObjectInputStream(bs);
    try{
      Certificate c = (Certificate)ois.readObject();
      return c;
    }catch(ClassNotFoundException e){
      e.printStackTrace();
      assert false;
    }
    return null;
  }

  public static void writeToStream(Certificate c, IrisOutputStream os, boolean optim) throws IOException{
    ByteArrayOutputStream bs = new ByteArrayOutputStream();
    ObjectOutputStream oos = new ObjectOutputStream(bs);
    oos.writeObject(c);
    oos.flush();
    os.writeInt(bs.size());
    os.write(bs.toByteArray());
  }
}
