package code.simulator;


public class IrisHashObject extends IrisObject{

  Hash hash;
  
  public IrisHashObject(Hash h){
    this.hash = h;
  }
  
  @Override
  public Hash getHash(){
    return hash;
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + ((hash == null) ? 0 : hash.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof IrisHashObject)){
      return false;
    }
    IrisHashObject other = (IrisHashObject) obj;
    if(hash == null){
      if(other.hash != null){
        return false;
      }
    }else if(!hash.equals(other.hash)){
      return false;
    }
    return true;
  }

  @Override
  public String toString(){
    return "IrisHashObject [hash=" + hash + "]";
  }

  
}
