package code.simulator;

import code.branchDetecting.*;

import code.security.SangminConfig;

public class NodeFactory{
  
  public static Node createNode(BranchID bid){
    return new Node(bid);
  }

  public static Node createIrisNode(BranchID bid, BranchID configIdx){
    IrisNode ret = new IrisNode(bid, configIdx);
//    if(bid.getIDint()>8){
//      System.out.println("Setting node " + bid.getIDint() + " to commit omission.");  
//      ret.omission_fault = false;
//    }
    if(!Node.enableSecurity)
      return ret;
    //ret.addSyncFilter(new InstantGCProtocol());
    //ret.addSyncFilter(new GCProtocol(10));
    /*
    if(bid.getIDint() == 0){
      ret.addSyncFilter(new GCProtocol(8));
    } else {
      ret.addSyncFilter(new GCProtocol(10000));
    }*/      
    

    
    /*
    EvictionProtocol ev;
    if(bid.getIDint() == 0){
      System.out.println("Installing eviction filter at 0");
      ev = new EvictionProtocol(10000);
    } else {
      ev = new EvictionProtocol(10000);
    }        
    ret.addSyncFilter(ev);
    ret.addDiscardeWriteFilter(ev);
    ret.addPOMFilter(ev);
    ret.addSyncFilter(new BWSyncFilter());
    */
    
    return ret;
  }
  
//  public static Node createIrisNode(BranchID bid, BranchID configIdx){
//    IrisNode ret = new IrisNode(bid, configIdx);
//    if(!Node.enableSecurity)
//      return ret;
//
//  //  ret.addSyncFilter(new EvictionProtocol(100));
//    ret.addSyncFilter(new GCProtocol(10));
//
//    return ret;
//  }
  
  public static Node createIrisNode(BranchID bid){
    return createIrisNode(bid, bid);
  }
  
  public static Node createNodeWithoutFilter(BranchID bid){
    IrisNode ret = new IrisNode(bid);
    //Node ret = new Node(bid);
    return ret;
  }
  
  public static Node createConfigNodeWithoutFilter(BranchID bid, String config){
    IrisNode ret = new IrisNode(bid, config);
    //Node ret = new Node(bid);
    return ret;
  }

  public static BranchID createNodeId(long id){
    if(SangminConfig.useSimulatorId){
      return new SimBranchID(id);
    }else{
      return new BranchID(id);
    }
  }
  
  
}
