package code.simulator;

import java.util.Iterator;
import java.util.TreeSet;

import code.ObjId;
import code.SubscriptionSet;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.simulator.protocolFilters.AgreementGCProtocol;
import code.simulator.store.*;

public class OracleNotifier {

  static protected Store oracleStore;

  static{
    oracleStore = new Store();
    oracleStore.setIgnoreSet(SubscriptionSet.makeSubscriptionSet(AgreementGCProtocol.gcProposalDir+"*"));
  }

  public static void notifyWrite(SimPreciseInv spi, BranchID bid, boolean omissionFaulty){
    if(!omissionFaulty // whether to include faulty node's state 
        && !spi.isEmbargoed() && 
        SangminConfig.enableOracle){ // apply writes that are not modified by the faulty nodes
      oracleStore.apply(spi);
    }
  }

  public static int calculateInconsistecy(StoreInterface nodeStore){
    int inconsistency = 0;

    Iterator<ObjId> iter = oracleStore.iterator();

    if(SangminConfig.enableOracle){
      int nobj = 0;
      while(iter.hasNext()){
        ObjId oid = iter.next();
        if(!nodeStore.containsKey(oid)){
          inconsistency++;
        } else {
          TreeSet<StoreEntry> nodeObj = nodeStore.get(oid);
          TreeSet<StoreEntry> oracleObj = oracleStore.get(oid);
          if(!nodeObj.equals(oracleObj)){
            inconsistency++;
          }
        }
        nobj++;

      }
    }
    
    return inconsistency;
  }

  public static String getStoreString(){
    return oracleStore.toString();
  }

}
