package code.simulator;

import code.AcceptStamp;
import code.NodeId;

/**
 * All origNodeId values with timestamp equal or higher than ts should be renamed to newNodeId
 * Smaller ts values are left unchanged
 * @author princem
 *
 */
public class POMRemap{

  private NodeId origNodeId;
  private NodeId newNodeId;
  private long ts;
  private boolean init = false;

  public POMRemap(){
    origNodeId = null;
    newNodeId = null;
    ts = -1;
    init = false;
  } 
  
  /**
   * @param origNodeId
   * @param newNodeId
   * @param ts
   */
  public POMRemap(NodeId origNodeId, NodeId newNodeId, long ts){
    this.origNodeId = origNodeId;
    this.newNodeId = newNodeId;
    this.ts = ts;
    init = true;
  }
  
  public void init(NodeId origNodeId, NodeId newNodeId, long ts){
    this.origNodeId = origNodeId;
    this.newNodeId = newNodeId;
    this.ts = ts;
    init = true;
  }

  public NodeId getOrigNodeId(){
    return origNodeId;
  }

  public NodeId getNewNodeId(){
    return newNodeId;
  }

  public long getTs(){
    return ts;
  }
  
  public AcceptStamp applyPOMRemap(AcceptStamp as){
    if(!as.getNodeId().equals(origNodeId) || as.getLocalClock() < ts){
      return as;
    }else{
      return new AcceptStamp(as.getLocalClock(), newNodeId);
    }
  }

  public boolean isInit(){
    return init;
  }
}
