package code.simulator;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import code.branchDetecting.*;
import code.security.SangminConfig;
import code.serialization.IrisInputStream;
import code.serialization.IrisOutputStream;
/**
 * POM is a cryptographic evidence against a node
 * @author princem
 *
 */
public class ProofOfMisbehavior implements Serializable{
  
  final SimPreciseInv parent;
  final SimPreciseInv child1;
  final SimPreciseInv child2;
  
  public ProofOfMisbehavior(SimPreciseInv parent, SimPreciseInv child1, SimPreciseInv child2){
    this.parent = parent;
    this.child1 = child1;
    this.child2 = child2;
    
  }
  
  public ProofOfMisbehavior(SimPreciseInv parent){
    this.parent = parent;
    this.child1 = null;
    this.child2 = null;
   // assert SangminConfig.useSimulatorId;
    
  }
  
  public boolean verify(){
    return true;
  }
  
  

  public SimPreciseInv getParent(){
    return parent;
  }

  public String toString(){
    return "POM" + (parent!=null?parent.toString():"NULL") + " : children <" + child1 + " " + child2 + " >";
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + ((child1 == null) ? 0 : child1.hashCode());
    result = prime * result + ((child2 == null) ? 0 : child2.hashCode());
    result = prime * result + ((parent == null) ? 0 : parent.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof ProofOfMisbehavior)){
      return false;
    }
    ProofOfMisbehavior other = (ProofOfMisbehavior) obj;
    if(child1 == null){
      if(other.child1 != null){
        return false;
      }
    }else if(!child1.equals(other.child1)){
      return false;
    }
    if(child2 == null){
      if(other.child2 != null){
        return false;
      }
    }else if(!child2.equals(other.child2)){
      return false;
    }
    if(parent == null){
      if(other.parent != null){
        return false;
      }
    }else if(!parent.equals(other.parent)){
      return false;
    }
    return true;
  }

  public SimPreciseInv getChild1(){
    return child1;
  }

  public SimPreciseInv getChild2(){
    return child2;
  }
  
  public static ProofOfMisbehavior readFromStream(IrisInputStream is, boolean optim) throws IOException{

    boolean cpom = is.readBoolean();
    SimPreciseInv parent = null, child1 = null, child2 = null;
    if(is.readBoolean()){
      parent = new SecureSimPreciseInv();
      parent.readFromStream(is, false);
    }
    if(is.readBoolean()){
      child1 = new SecureSimPreciseInv();
      child1.readFromStream(is, false);
    }
    if(is.readBoolean()){
      child2 = new SecureSimPreciseInv();
      child2.readFromStream(is, false);
    }
    if(cpom){
      return new ConcurrentPOM(child1, child2);
    }else{
      return new ProofOfMisbehavior(parent, child1, child2);
    }
  }

  public static void writeToStream(ProofOfMisbehavior c, IrisOutputStream os, boolean optim) throws IOException{
    if(c instanceof ConcurrentPOM){
      os.writeBoolean(true);
    }else{
      os.writeBoolean(false);
    }
    if(c.parent != null){
      os.writeBoolean(true);
      c.parent.writeToStream(os, false);
    }else{
      os.writeBoolean(false);
    }
    if(c.child1 != null){
      os.writeBoolean(true);
      c.child1.writeToStream(os, false);
    }else{
      os.writeBoolean(false);
    }
    if(c.child2 != null){
      os.writeBoolean(true);
      c.child2.writeToStream(os, false);
    }else{
      os.writeBoolean(false);
    }
  }
  
}
