package code.simulator;

import code.AcceptVV;
import code.AcceptStamp;
import code.Config;
import code.CounterVV;
import code.NoSuchEntryException;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.PreciseInv;
import code.security.Crypto;
import code.security.SangminConfig;
import code.VVIterator;
import code.branchDetecting.BranchID;
import code.security.SecurePreciseInv;
import code.security.ahs.DependencyVV;
import code.serialization.IrisInputStream;
import code.serialization.IrisObjectInputStream;
import code.serialization.IrisObjectOutputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.serialization.SerializationHelper;
import code.simulator.log.Log;
import code.simulator.protocolFilters.AgreementGCProtocol;
import code.simulator.store.Store;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ClassCastException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Map.Entry;
import java.io.Serializable;

public class SecureSimPreciseInv extends SimPreciseInv implements Obj2Bytes, IrisSerializable{

  final byte epoch;
  /**
   * @return the epoch
   */
  @Override
  public int getEpoch(){
    return epoch;
  }

  protected byte[]      signature;

  private boolean consistent = false;

  public SecureSimPreciseInv(){
    //super();
    epoch = -1;
    //    myHash = null;
  }

  /**
   * Constructor for the case when 
   * @param obj_
   * @param acceptStamp_
   * @param dvv
   * @param data
   * @param hash
   * @param epoch
   * @param objectHashes
   */
  public SecureSimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, IrisObject data, int epoch, 
      TreeSet<Hash> objectHashes){
    super(obj_, acceptStamp_, dvv, data, objectHashes, false);
    signature = null;
    this.epoch = (byte)epoch;

    if(Node.useSignature){
      signature = sign(
          Config.privateKeys.get((acceptStamp_.getNodeId().getIDint())));
    }

  }

  public SecureSimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, int epoch, 
      TreeSet<Hash> objectHashes){
    super(obj_, acceptStamp_, dvv, Store.deleteObject, objectHashes, true);
    signature = null;
    this.epoch = (byte)epoch;

    if(Node.useSignature){
      signature = sign(
          Config.privateKeys.get((acceptStamp_.getNodeId().getIDint())));
    }

  }

  public SecureSimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, IrisObject data, 
      byte[] sig, boolean embargoed, TreeSet flags,TreeSet<Hash> objectHashes, int epoch){
    super(obj_, acceptStamp_, dvv, data, embargoed, flags, objectHashes, false);
    signature = sig;
    this.epoch = (byte)epoch;
  }

  public SecureSimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, 
      byte[] sig, boolean embargoed, TreeSet flags,TreeSet<Hash> objectHashes, int epoch){
    super(obj_, acceptStamp_, dvv, Store.deleteObject, embargoed, flags, objectHashes, true);
    signature = sig;
    this.epoch = (byte)epoch;
  }

  //  private SecureSimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, Object data, Hash hash,
  //      byte[] signature,TreeSet<Hash> objectHashes, int epoch){
  //    super(obj_, acceptStamp_, dvv, data, objectHashes);
  //    this.hash = hash;
  //    assert hash.equals(Log.getHash((HashedVV)dvv));
  //    assert hash != null;
  //    this.epoch = epoch;
  //    assert epoch >= 0;
  //    this.signature = signature;
  //  }

  private SecureSimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, IrisObject data, int epoch, 
      byte[] signature, TreeSet<Hash> objectHashes, boolean _delete){
    super(obj_, acceptStamp_, dvv, data, objectHashes, _delete);
    this.epoch = (byte)epoch;
    assert epoch >= 0;
    this.signature = signature;
  }

  //  public SecureSimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, DependencyVV dvv, Object data, Hash hash,
  //      PrivateKey privKey){
  //    this(obj_, acceptStamp_, dvv, data, hash);
  //    signature = sign(privKey);
  //    
  //  }

  protected byte[] sign(PrivateKey privKey){
    assert (privKey != null);

    //  if(SangminConfig.disableSignatureVerfication){
    //  byte[] b =new byte[1];
    //  b[0] = (byte)0;
    //  return b;
    //  }else{
    try{
      //Signature sig = Signature.getInstance(privKey.getAlgorithm());
	//      long start  = System.currentTimeMillis();
      Signature sig = Crypto.getSignature();	
      sig.initSign(privKey);           
      sig.update(this.obj2Bytes());
      byte[] ret = sig.sign();
      Crypto.returnSignature(sig);
      //      long end = System.currentTimeMillis();
      //      System.out.println(" signing took " + (end-start));
      return ret;
    }catch(Exception e){
      System.out.println(e.toString());
      System.out.println(e.getStackTrace());
      System.exit(-1);
    }
    return null;
  }

  //public boolean verify(PublicKey pubKey){
  @Override
  public boolean verifySig(){
    if(!Node.enableSecurity){
      return true;
    }

    if(!Node.useSignature) return true;
    PublicKey pubKey = Config.publicKeys.get(this.acceptStamp.getNodeId().getIDint());
    try{
      //Signature sig = Signature.getInstance(pubKey.getAlgorithm());
      Signature sig = Crypto.getSignature();	
      sig.initVerify(pubKey);

      //      SerializationHelper sh = this.obj2BytesExcludingSignature();
      //      sh.close();
      sig.update(this.obj2Bytes());
      assert this.signature != null;
      boolean ret = sig.verify(this.signature);
      Crypto.returnSignature(sig);
      return ret;
    }catch(Exception e){
      System.out.println(e.toString());
      System.out.println(e.getStackTrace());
      System.exit(-1);
    }

    return false;

  }


  public int hashCode(){
    //return dvv.hashCode() + data.hashCode() + this.acceptStamp.hashCode() + new Long(this.getStart()).hashCode() + this.obj.hashCode() + hash.hashCode();
    return super.hashCode() + new Integer(epoch).hashCode();
  }

  public int compareTo(Object o) throws ClassCastException{
    if(!(o instanceof SecureSimPreciseInv)){
      throw new ClassCastException();
    }
    int res = super.compareTo(o);
    if(res != 0){
      return res;
    }else{
      SecureSimPreciseInv sspi = (SecureSimPreciseInv)o;
      return new Integer(epoch).compareTo(new Integer(sspi.epoch));
    }
  }

  public AcceptVV getDVV(){
    return dvv;
  }

  @Override
  public Hash getHash(NodeId n) throws NoSuchEntryException {
    assert this.dvv instanceof HashedVV;
    HashedVV hdvv = (HashedVV)dvv;
    return hdvv.getHashByServer(n);
  }

  public boolean equals(Object o){
    if(!(o instanceof SecureSimPreciseInv)){
      return false;
    }else{
      SecureSimPreciseInv spi = (SecureSimPreciseInv)o;
      return super.equals(o) && epoch == spi.epoch;
    }
  }

  public boolean equalsIgnoringFlags(Object o){
    if(!(o instanceof SecureSimPreciseInv)){
      return false;
    }else{
      SecureSimPreciseInv spi = (SecureSimPreciseInv)o;
      return super.equalsIgnoringFlags(o) && epoch == spi.epoch;
    }
  }

  @Override
  public boolean equalsIgnoreBranches(SimPreciseInv spi){
    assert spi instanceof SecureSimPreciseInv;
    return Arrays.equals(this.obj2Bytes(), ((SecureSimPreciseInv)spi).obj2Bytes());
  }

  public String toString(){
    //return acceptStamp.toString() + " DVV:" + dvv + " data: " + data;
    return super.toString() + " epoch " + epoch + ", consistent: " + consistent;
  }

  @Override
  public Hash getHash(){
    return ((HashedVV)dvv).getHash();
  }

  @Override
  public Hash generateMyHash(){
    if(Node.enableSecurity){
      Hash newHash = new Hash(this);
      //    assert newHash.equals(myHash);
      return newHash;
    }else{
      return Hash.NullHash;
    }
  }

  @Override
  public SecureSimPreciseInv cloneWithNewNodeId(NodeId newId){
    SecureSimPreciseInv ret = new SecureSimPreciseInv(this.obj.getObjId(), 
        new AcceptStamp(super.acceptStamp.getLocalClock(),newId), 
        this.dvv, 
        this.data, this.epoch, this.signature, objectHashes, delete);    
    ret.flags.addAll(this.flags);
    assert ret.generateMyHash().equals(this.generateMyHash());
    assert this.verifySig();
    return ret;
  }


  public SecureSimPreciseInv applyBranchMap(HashMap<NodeId, NodeId> branchMap){
    AcceptStamp as;
    if(branchMap.containsKey(acceptStamp.getNodeId())){
      as = new AcceptStamp(super.acceptStamp.getLocalClock(), branchMap.get(super.acceptStamp.getNodeId()));
    }else{
      as = super.acceptStamp;
    }
    SecureSimPreciseInv ret = new SecureSimPreciseInv(this.obj.getObjId(), 
        as, 
        this.dvv.applyBranchMap(branchMap), 
        this.data,this.epoch, this.signature, objectHashes, delete);    
    ret.flags.addAll(this.flags);
    assert ret.generateMyHash().equals(this.generateMyHash());
    assert this.verifySig();
    return ret;
  }

  //  /**
  //   * Update oldId of dvv to newId if the oldId's time stamp is greater 
  //   * than or equal to timestamp 
  //   * @param oldId NodeId to be updated
  //   * @param timestmp
  //   * @param newId new NodeId
  //   * @return true if this dvvMap has oldId component to be updated,
  //   *  false otherwise
  //   */
  //  public SecureSimPreciseInv updateDVV(POMRemap remap){
  //    CounterVV newDVV = new CounterVV();
  //    HashedDependencyVV hdvv = (HashedDependencyVV)dvv;
  //    VVIterator vvi = dvv.getIterator();
  //    HashMap<NodeId, Hash> hashes = new HashMap<NodeId, Hash>();
  //    while(vvi.hasMoreElements()){
  //      NodeId n = vvi.getNext();
  //      if(n.equals(remap.getOrigNodeId()) && dvv.getStampByIteratorToken(n) >= remap.getTs()){
  //        AcceptStamp as =new AcceptStamp(dvv.getStampByIteratorToken(n), remap.getNewNodeId());
  //        if(!newDVV.includes(as)){
  //          newDVV.addMaxAS(as);
  //          hashes.put(remap.getNewNodeId(), hdvv.getHashByIteratorToken(n));
  //        }
  //      }else{
  //        newDVV.addMaxAS(new AcceptStamp(dvv.getStampByIteratorToken(n), n));
  //        hashes.put(n, hdvv.getHashByIteratorToken(n));
  //      }
  //    }
  //    SecureSimPreciseInv ret = new SecureSimPreciseInv(this.obj.getObjId(), 
  //        this.getAcceptStamp(), 
  //        new HashedDependencyVV(newDVV, hashes), 
  //        this.databytes, 
  //        this.hash, this.epoch, this.signature);    
  //    ret.flags.addAll(this.flags);  
  //    
  //    return ret;
  //  }

  /**
   * Update oldId of dvv to newId if the oldId's time stamp is greater 
   * than or equal to timestamp 
   * @param oldId NodeId to be updated
   * @param timestmp
   * @param newId new NodeId
   * @return true if this dvvMap has oldId component to be updated,
   *  false otherwise
   */
  @Override
  public SimPreciseInv updateDVV(POMRemap remap){
    HashedVV hdvv = (HashedVV)dvv;
    HashedVV newHDVV = hdvv.applyPOMRemap(remap);
    assert Log.getHash(hdvv).equals(Log.getHash(newHDVV));
    SecureSimPreciseInv ret = new SecureSimPreciseInv(this.obj.getObjId(), 
        this.getAcceptStamp(), 
        newHDVV, 
        this.data,
        this.epoch, this.signature, objectHashes, delete);    
    ret.flags.addAll(this.flags);  
    assert this.verifySig();
    return ret;
  }

  @SuppressWarnings("unchecked")
  @Override
  public byte[] obj2Bytes(){
    try{
      SerializationHelper serHelper = new SerializationHelper();
      ObjectOutput oos = serHelper.getObjectOutputStream();
      HashedVV hdvv = (HashedVV)dvv;
      oos.write(hdvv.getHash().getHashVal());
      oos.write(this.getObjId().getPath().getBytes());
      oos.writeLong(this.getAcceptStamp().getLocalClock());
      oos.writeLong(this.getAcceptStamp().getNodeId().getIDint());
      //oos.writeObject(this.data);
      oos.write(this.data.getHash().obj2Bytes());
      oos.writeInt(epoch);
      oos.writeBoolean(delete);
      oos.writeInt(objectHashes.size());
      for(Hash h: objectHashes){
        oos.write(h.getHashVal());
      }
      serHelper.close();
      return serHelper.toBytes();
    }catch(Exception e){
      e.printStackTrace();
    }
    assert false;
    return null;

  }
  //  public void readExternal(ObjectInput in) 
  //  throws IOException, ClassNotFoundException{
  //    this.readExternal(in, SangminConfig.optimizeDVVMapHashes);
  //  }

  /**
   * optimize--> whether to omit the hash or not
   * SangminConfig.optimizeDVVHashes--wheter to remove hashes for individual components
   * @param in
   * @param optimize
   * @throws IOException
   * @throws ClassNotFoundException
   */
  public void readExternal(ObjectInput in) 
  throws IOException, ClassNotFoundException{

    String str = SerializationHelper.readShortString(in);
    ObjId objId = new ObjId(str);

    AcceptStamp as = new AcceptStamp();
    as.readExternal(in);

    HashedVV _dvv = null;
    if(Node.enableSecurity){
      //      int numNodesInDVV = in.readInt();
      //      HashMap<NodeId, Hash> hashes = new HashMap<NodeId, Hash>();
      //      for(int i=0; i < numNodesInDVV; i++){
      //        byte[] hash = new byte[Hash.Length];
      //          NodeId nodeId = (NodeId)in.readObject();
      //        _vv.put(nodeId, in.readLong());
      //        in.readFully(hash);
      //        hashes.put(nodeId, new Hash(hash, false));
      //      }
      _dvv = new HashedVV();
      _dvv.readExternal(in);
      //      _dvv = (HashedVV)in.readObject();

    }else{
      _dvv = new HashedVV();
    }
    byte[] sig = null;
    if(Node.useSignature){
      int sigSize = in.readShort();
      sig = new byte[sigSize];
      in.readFully(sig);
    }
    boolean _delete = in.readBoolean();
    IrisObject data;
    if(_delete){
      data = Store.deleteObject;
    }else{
      if(SangminConfig.separateBodies && !(str.startsWith(AgreementGCProtocol.gcProposalDir))){
        byte[] hass = new byte[Hash.Length];
        in.readFully(hass);
        data = new IrisHashObject(new Hash(hass, false));
      }else{
        //        data = (IrisObject)in.readObject();
        short len = in.readShort();
        byte[] dataArr = new byte[len];
        in.readFully(dataArr);
        data = new IrisDataObject(dataArr);
      }
    }
    byte _epoch = in.readByte();

    int size = in.readByte();
    TreeSet<Hash> _objHashes = new TreeSet<Hash>();
    for(int i = 0; i < size; i++){
      byte[] _hash = new byte[Hash.Length];
      in.readFully(_hash);
      _objHashes.add(new Hash(_hash, false));
    }


    int hopcount=-1;
    if(SimPreciseInv.useHopCount){
      hopcount = in.readInt();
    }

    Field[] f = new Field[12];

    try{

      f[0] = PreciseInv.class.getDeclaredField("obj");
      f[1] = PreciseInv.class.getDeclaredField("acceptStamp");
      f[2] = PreciseInv.class.getDeclaredField("rtAcceptStamp");
      f[3] = PreciseInv.class.getDeclaredField("embargoed");
      f[4] = PreciseInv.class.getDeclaredField("committed");
      f[5] = SimPreciseInv.class.getDeclaredField("dvv");
      f[6] = SimPreciseInv.class.getDeclaredField("data");
      //      f[6] = SimPreciseInv.class.getDeclaredField("databytes");
      f[7] = SecureSimPreciseInv.class.getDeclaredField("signature");
      f[8] = SecureSimPreciseInv.class.getDeclaredField("epoch");
      f[9] = SimPreciseInv.class.getDeclaredField("objectHashes");
      f[10] = SimPreciseInv.class.getDeclaredField("hopCount");
      f[11] = SimPreciseInv.class.getDeclaredField("delete");

    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, new ObjInvalTarget(objId,
          0,
          1));
      f[1].set(this, as);
      f[2].set(this, as);
      f[3].setBoolean(this, false);
      f[4].setBoolean(this, false);
      f[5].set(this, _dvv);
      f[6].set(this, data);
      f[7].set(this, sig);
      f[8].set(this, _epoch);
      f[9].set(this, _objHashes);
      f[10].set(this, hopcount);
      f[11].set(this, _delete);


    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }

  }

  /**
   * @return the initialized
   */
  public boolean isInitialized(){
    return ((HashedVV)this.dvv).isInitialized();
  }

  public boolean initialize(HashMap<NodeId, Hash> hashes2){
    return ((HashedVV)this.dvv).initialize(hashes2);
  }

  public void writeExternal(ObjectOutput out) throws IOException{
    writeExternal(out, false); 
  }

  public void writeExternal(ObjectOutput out, boolean optimize) throws IOException{

    SerializationHelper.writeShortString(this.getObjId().getPath(), out);

    this.getAcceptStamp().writeExternal(out);    

    if(Node.enableSecurity){
      //      out.writeInt(dvv.getSize());
      HashedVV hdvv = (HashedVV)dvv;
      //      out.writeObject(hdvv);
      if(flags.isEmpty()){
        hdvv.writeExternal(out, optimize);
      }else{
        hdvv.writeExternal(out);
      }
      //      //System.out.println("WRITE numNodesInDVV : " + dvv.getSize());
      //      for( NodeId nodeId: dvv.getNodes()){
      //        try{
      //          //out.writeLong(nodeId.getIDint());
      //          out.writeObject(nodeId);
      //          out.writeLong(dvv.getStampByServer(nodeId));
      //          out.write(hdvv.getHashByIteratorToken(nodeId).getHashVal());
      //        }catch(Exception e){
      //          e.printStackTrace();
      //          System.exit(-1);
      //        }
      //      }

    }
    if(Node.useSignature){
      out.writeShort(signature.length);
      out.write(signature);
    }
    //out.writeObject(data);
    out.writeBoolean(delete);
    if(!delete){
      //      out.writeObject(data);
      if(SangminConfig.separateBodies && !(this.getObjId().getPath().startsWith(AgreementGCProtocol.gcProposalDir))){
        out.write(data.getHash().getHashVal());
      }else{
        //        data = (IrisObject)in.readObject();
        assert data instanceof IrisDataObject;
        IrisDataObject ido = (IrisDataObject)data;
        short len = (short)ido.getUnsafeBytes().length;
        out.writeShort(len);
        out.write(ido.getUnsafeBytes());
      }
    }
    out.writeByte(epoch);
    out.writeByte(objectHashes.size());
    for(Hash h: objectHashes){
      out.write(h.getHashVal());
    }
    if(SimPreciseInv.useHopCount){
      out.writeInt(hopCount);
    }
  }

  public static void testStr() throws IOException{
    SangminConfig.optimizeDVVMapHashes = false;
    DependencyVV dvv = new DependencyVV();
    dvv.put(new BranchID(5), 3);
    String data = "data";
    byte[] bytes = new byte[Hash.Length];
    for(int i=0; i<Hash.Length; i++){
      bytes[i] = 'a';
    }
    Config.readKeys();

    Hash hash = new Hash(bytes, false);
    HashMap<NodeId, Hash> hashes = new HashMap<NodeId, Hash>();
    hashes.put(new BranchID(5), hash);
    HashedVV hdvv = new HashedVV(dvv, hashes);

    TreeSet<Hash> objHashes = new TreeSet<Hash>();
    objHashes.add(Hash.NullHash);
    objHashes.add(hash);

    IrisObject irisData = new IrisDataObject(data.getBytes());
    SecureSimPreciseInv sspi = new SecureSimPreciseInv(new ObjId(SangminConfig.bodyAttachDir+"test"), new AcceptStamp(10,new BranchID(10)), hdvv, irisData , 0, objHashes);

    Hash h = sspi.generateMyHash();
    SecureSimPreciseInv sspi1 = (SecureSimPreciseInv)sspi.updateDVV(new POMRemap(new BranchID(5), new BranchID(5, 3, hash), 2));
    assert sspi.generateMyHash().equals(h);
    assert Arrays.equals(sspi1.obj2Bytes(), sspi.obj2Bytes()): "\n" + Arrays.toString(sspi1.obj2Bytes()) + "\n" + Arrays.toString(sspi.obj2Bytes());

    ByteArrayOutputStream bs;
    IrisOutputStream oos;

    bs = new ByteArrayOutputStream();
    oos = new IrisOutputStream(bs);
    System.out.println("Serialise it");
    //    oos.writeObject(sspi);
    sspi.writeToStream(oos, false);

    oos.flush();
    //bs.toByteArray();
    System.out.println("read it " + bs.toByteArray().length);
    SecureSimPreciseInv sspi2 = null;
    IrisInputStream ois = new IrisInputStream(new ByteArrayInputStream(bs.toByteArray()));
    //      sspi2 = (SecureSimPreciseInv)ois.readObject();
    sspi2 = new SecureSimPreciseInv();
    sspi2.readFromStream(ois, false);

    if(sspi.equals(sspi2)){
      System.out.println("Success");
    } else {
      System.out.println("Fail : \n" + sspi + "\n" + sspi2);

      assert sspi.data.equals(sspi2.data);
      if(Node.enableSecurity){
        assert sspi.dvv.equals(sspi2.dvv);
      }
      assert false;

    }
    
    bs = new ByteArrayOutputStream();
    oos = new IrisOutputStream(bs);
    System.out.println("Serialise it");
    //    oos.writeObject(sspi);
    sspi.writeToStream(oos, true);

    oos.flush();
    //bs.toByteArray();
    System.out.println("read it " + bs.toByteArray().length);
    sspi2 = null;
    ois = new IrisInputStream(new ByteArrayInputStream(bs.toByteArray()));
    //      sspi2 = (SecureSimPreciseInv)ois.readObject();
    sspi2 = new SecureSimPreciseInv();
    sspi2.readFromStream(ois, true);

    HashedVV hvv = (HashedVV)sspi.getDVV();
    HashMap<NodeId, Hash> map = new HashMap<NodeId, Hash>();
    for(Entry<NodeId, Hash> entry: hvv.getHashes()){
      map.put(entry.getKey(), entry.getValue()); 
    }
    HashedVV hvv2 = (HashedVV)sspi2.getDVV();
    hvv2.initialize(map);
    if(sspi.equals(sspi2)){
      System.out.println("Success");
    } else {
      System.out.println("Fail : \n" + sspi + "\n" + sspi2);

      assert sspi.data.equals(sspi2.data);
      if(Node.enableSecurity){
        assert sspi.dvv.equals(sspi2.dvv);
      }
      assert false;
    }

  }
  
  public static void testExt() throws IOException{
    Node.useSignature = true;
    SangminConfig.optimizeDVVMapHashes = false;
    DependencyVV dvv = new DependencyVV();
    dvv.put(new BranchID(5), 3);
    String data = "data";
    byte[] bytes = new byte[Hash.Length];
    for(int i=0; i<Hash.Length; i++){
      bytes[i] = 'a';
    }
    Config.readKeys();

    Hash hash = new Hash(bytes, false);
    HashMap<NodeId, Hash> hashes = new HashMap<NodeId, Hash>();
    hashes.put(new BranchID(5), hash);
    HashedVV hdvv = new HashedVV(dvv, hashes);

    TreeSet<Hash> objHashes = new TreeSet<Hash>();
    objHashes.add(Hash.NullHash);
    objHashes.add(hash);

    IrisObject irisData = new IrisDataObject(data.getBytes());
    SecureSimPreciseInv sspi = new SecureSimPreciseInv(new ObjId(AgreementGCProtocol.gcProposalDir+"test"), new AcceptStamp(10,new BranchID(10)), hdvv, irisData , 0, objHashes);

    Hash h = sspi.generateMyHash();
    SecureSimPreciseInv sspi1 = (SecureSimPreciseInv)sspi.updateDVV(new POMRemap(new BranchID(5), new BranchID(5, 3, hash), 2));
    assert sspi.generateMyHash().equals(h);
    assert Arrays.equals(sspi1.obj2Bytes(), sspi.obj2Bytes()): "\n" + Arrays.toString(sspi1.obj2Bytes()) + "\n" + Arrays.toString(sspi.obj2Bytes());

    ByteArrayOutputStream bs;
    ObjectOutputStream oos;

    bs = new ByteArrayOutputStream();
    oos = new IrisObjectOutputStream(bs);
    System.out.println("Serialise it");
    //    oos.writeObject(sspi);
    sspi.writeExternal(oos);

    oos.flush();
    //bs.toByteArray();
    System.out.println("read it " + bs.toByteArray().length);
    SecureSimPreciseInv sspi2 = null;
    ObjectInputStream ois = new IrisObjectInputStream(new ByteArrayInputStream(bs.toByteArray()));
    try{
      //      sspi2 = (SecureSimPreciseInv)ois.readObject();
      sspi2 = new SecureSimPreciseInv();
      sspi2.readExternal(ois);
    }catch(ClassNotFoundException e){
      e.printStackTrace();
    }

    if(sspi.equals(sspi2)){
      System.out.println("Success");
    } else {
      System.out.println("Fail : \n" + sspi + "\n" + sspi2);

      assert sspi.data.equals(sspi2.data);
      if(Node.enableSecurity){
        assert sspi.dvv.equals(sspi2.dvv);
      }
    }

  }
  public static void main(String[] args) throws IOException{
    Node.useSignature = true;
    Node.enableSecurity = true;
    testExt();
    testStr();
    //    sspi.replaceIrisObject(new IrisHashObject(sspi.getData().getHash()));
    //    assert sspi.generateMyHash().equals(sspi2.generateMyHash());

  }


  /**
   * returns whether the Hash of this inval is consistent with the current value of various fields. A debug function. 
   * @return
   */
  public boolean isConsistent(){
    return consistent;
  }

  @Override
  public void readFromStream(IrisInputStream in, boolean optimized)
  throws IOException{
    if(SangminConfig.sanityCheck){
      byte b = in.readByte();
      assert b == (byte)0xBB: b + " " + (byte)0xBB;
    }
    String str = in.readShortString();
    ObjId objId = new ObjId(str);

    AcceptStamp as = new AcceptStamp();
    as.readFromStream(in, optimized);

    HashedVV _dvv = null;
    if(Node.enableSecurity){
      //      int numNodesInDVV = in.readInt();
      //      HashMap<NodeId, Hash> hashes = new HashMap<NodeId, Hash>();
      //      for(int i=0; i < numNodesInDVV; i++){
      //        byte[] hash = new byte[Hash.Length];
      //          NodeId nodeId = (NodeId)in.readObject();
      //        _vv.put(nodeId, in.readLong());
      //        in.readFully(hash);
      //        hashes.put(nodeId, new Hash(hash, false));
      //      }
      _dvv = new HashedVV();
      _dvv.readFromStream(in, optimized, as.getLocalClock());
//      _dvv.readFromStream(in, optimized, 0);
      //      _dvv = (HashedVV)in.readObject();

    }else{
      _dvv = new HashedVV();
    }
    byte[] sig = null;
    if(Node.useSignature){
      int sigSize = in.readShort();
      sig = new byte[sigSize];
      in.readFully(sig);
    }
    boolean _delete = in.readBoolean();
    IrisObject data;
    if(_delete){
      data = Store.deleteObject;
    }else{
      if(SangminConfig.separateBodies && 
          !(str.startsWith(AgreementGCProtocol.gcProposalDir) || str.startsWith(SangminConfig.bodyAttachDir))){
        byte[] hass = new byte[Hash.Length];
        in.readFully(hass);
        data = new IrisHashObject(new Hash(hass, false));
      }else{
        //        data = (IrisObject)in.readObject();
        short len = in.readShort();
        byte[] dataArr = new byte[len];
        in.readFully(dataArr);
        data = new IrisDataObject(dataArr);
      }
    }
    byte _epoch = in.readByte();

    int size = in.readByte();
    TreeSet<Hash> _objHashes = new TreeSet<Hash>();
    for(int i = 0; i < size; i++){
      byte[] _hash = new byte[Hash.Length];
      in.readFully(_hash);
      _objHashes.add(new Hash(_hash, false));
    }


    int hopcount=-1;
    if(SimPreciseInv.useHopCount){
      hopcount = in.readInt();
    }

    Field[] f = new Field[12];

    try{

      f[0] = PreciseInv.class.getDeclaredField("obj");
      f[1] = PreciseInv.class.getDeclaredField("acceptStamp");
      f[2] = PreciseInv.class.getDeclaredField("rtAcceptStamp");
      f[3] = PreciseInv.class.getDeclaredField("embargoed");
      f[4] = PreciseInv.class.getDeclaredField("committed");
      f[5] = SimPreciseInv.class.getDeclaredField("dvv");
      f[6] = SimPreciseInv.class.getDeclaredField("data");
      //      f[6] = SimPreciseInv.class.getDeclaredField("databytes");
      f[7] = SecureSimPreciseInv.class.getDeclaredField("signature");
      f[8] = SecureSimPreciseInv.class.getDeclaredField("epoch");
      f[9] = SimPreciseInv.class.getDeclaredField("objectHashes");
      f[10] = SimPreciseInv.class.getDeclaredField("hopCount");
      f[11] = SimPreciseInv.class.getDeclaredField("delete");

    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, new ObjInvalTarget(objId,
          0,
          1));
      f[1].set(this, as);
      f[2].set(this, as);
      f[3].setBoolean(this, false);
      f[4].setBoolean(this, false);
      f[5].set(this, _dvv);
      f[6].set(this, data);
      f[7].set(this, sig);
      f[8].set(this, _epoch);
      f[9].set(this, _objHashes);
      f[10].set(this, hopcount);
      f[11].set(this, _delete);


    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    if(SangminConfig.sanityCheck){
      byte b = in.readByte();
      assert b == (byte)0xBC: b + " " + (byte)0xBC;
    }
  }

  @Override
  public void writeToStream(IrisOutputStream out, boolean optimized)
  throws IOException{
    if(SangminConfig.sanityCheck){
     out.writeByte(0xBB);
    }
//    optimized = false;
    out.writeShortString(this.getObjId().getPath());

    this.getAcceptStamp().writeToStream(out, optimized);    

    if(Node.enableSecurity){
      HashedVV hdvv = (HashedVV)dvv;
      if(flags.isEmpty()){
//        hdvv.writeToStream(out, optimized, 0);
        hdvv.writeToStream(out, optimized, this.getAcceptStamp().getLocalClock());

      }else{
        hdvv.writeToStream(out, false);
      }
    }
    if(Node.useSignature){
      out.writeShort(signature.length);
      out.write(signature);
    }
    out.writeBoolean(delete);
    if(!delete){
      if(SangminConfig.separateBodies && 
          !(this.getObjId().getPath().startsWith(AgreementGCProtocol.gcProposalDir) || this.getObjId().getPath().startsWith(SangminConfig.bodyAttachDir))){
        out.write(data.getHash().getHashVal());
      }else{
        assert data instanceof IrisDataObject;
        IrisDataObject ido = (IrisDataObject)data;
        short len = (short)ido.getUnsafeBytes().length;
        out.writeShort(len);
        out.write(ido.getUnsafeBytes());
      }
    }
    out.writeByte(epoch);
    out.writeByte(objectHashes.size());
    for(Hash h: objectHashes){
      out.write(h.getHashVal());
    }
    if(SimPreciseInv.useHopCount){
      out.writeInt(hopCount);
    }
    if(SangminConfig.sanityCheck){
      out.writeByte(0xBC);
     }

  }


}
