package code.simulator;

import code.NodeId;
import java.util.Arrays;
import java.util.HashMap;
import code.branchDetecting.*;

public class SimBranchID extends BranchID {

  final SimBranchID parent;
  final int childCount;
  
  public SimBranchID(SimBranchID parent, int childCount){
    super(-1);
    this.childCount = childCount;
    this.parent = parent;
  }
  
  public SimBranchID(long n){
    super(n);
    this.childCount = 0;
    this.parent = null;
  }

  public NodeId getBaseId(){
    if(parent == null){
      return this;
    }else{
      return parent.getBaseId();
    }
  }
  
  public boolean isForked(){
    return parent !=null;
  }
  
  public boolean isConcurrentForkedBranch(NodeId n){
    assert n instanceof SimBranchID:n;
    // return true if neither branch is contained in other
    return !(this.contains((SimBranchID)n) || ((SimBranchID)n).contains(this));
  }
  
  public boolean contains(SimBranchID bid){
    if(this.getIDint() != bid.getIDint()){
      return false;
    }else{
      // if either I am equal to the given branch or 
      return (this.equals(bid) || (this.parent != null && this.parent.contains(bid)));
    }
    
  }
  
  public boolean contains(NodeId bid){
    if(this.getIDint() != bid.getIDint()){
      return false;
    }else{
      // if either I am equal to the given branch or 
      return (this.parent == null || (this.parent != null && this.parent.contains(bid)));
    }
    
  }
  
  /* overrides hashCode in class object */
  public int hashCode(){
    return new Integer(childCount).hashCode()+(parent!=null?parent.hashCode():super.hashCode());
  }
  
  @Override
  public long getIDint(){
    if (parent == null){
      return super.getIDint();
    }else{
      return parent.getIDint();
    }
  }
  public boolean isValid()
  {
    long _id = getIDint();
      if(_id >= 0 || _id == WILDCARD_NODE_ID){
          return true;
      }
      return false;
  }

//
// Valid and not a wildcard
//
  public boolean isValidAndConcrete()
  {
    long _id = getIDint();

      if(_id >= 0){
          return true;
      }
      return false;
  }
  
  
  
  @Override
  /**
   * Compare NodeId first, then start time stamp and then hash value
   */
  public int compareTo(Object o) throws ClassCastException
  {
    int res = 0;
    long myIdInt = getIDint();
    long otherIdInt = -1;
    if(!(o instanceof NodeId)){
      System.out.println(o + " class: " +  o.getClass());
      throw new ClassCastException(o.getClass() + " " + o);
    }else{
      NodeId n = (NodeId)o;
      otherIdInt = n.getIDint();
    }
     
    if(myIdInt > otherIdInt){
      res = 1;
    }else if(myIdInt < otherIdInt){
      res = -1;
    }
    else{
      SimBranchID bid2 = (SimBranchID)o;
      if(this.parent != null && bid2.parent != null){
        res = parent.compareTo(bid2.parent);
        if(res == 0){
          if(this.childCount != bid2.childCount){
            res = this.childCount<bid2.childCount?-1:1;
          }
        }
      }else if(parent!=null){
        res = 1;
      }else if(bid2.parent != null){
        res = -1;
      }
    }
    return res;
  }

  /* overrides equals in class object */
  public boolean equals(Object nid){
    if(!(nid instanceof SimBranchID)){
      return false;
    }else{
      return compareTo(nid)==0;
    }
  }
  
  public String toString(){
    return "[SIMBranchID:"+(parent!=null?"parent:"+parent+", childCount:"+childCount:super.toString()) +"]";
  }
  
  public static void main(String[] args){
    SimBranchID bid1 = new SimBranchID(0);
    SimBranchID bid2 = new SimBranchID(1);
    assert bid1.compareTo(bid2) < 0;
    SimBranchID bid3 = new SimBranchID(bid1, 0);
    assert !bid1.equals(bid3);
    assert bid1.hashCode() != bid3.hashCode();
    HashMap h = new HashMap();
    h.put(bid1, 2);
    assert !h.containsKey(bid3);
    assert h.containsKey(bid1);
  }
}
