package code.simulator;

import code.AcceptStamp;
import code.AcceptVV;
import code.CounterVV;
import code.NoSuchEntryException;
import code.NodeId;
import code.ObjId;
import code.ObjInvalTarget;
import code.PreciseInv;
import code.branchDetecting.BranchID;
import code.security.SangminConfig;
import code.security.ahs.DependencyVV;
import code.serialization.IrisInputStream;
import code.serialization.IrisObjectInputStream;
import code.serialization.IrisObjectOutputStream;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.serialization.SerializationHelper;
import code.simulator.agreement.Tuple;
import code.simulator.log.Log;
import code.simulator.protocolFilters.AgreementGCProtocol;
import code.simulator.protocolFilters.GCProtocol;
import code.simulator.protocolFilters.SimpleGCProtocol;
import code.simulator.store.Store;


import java.io.*;
import java.lang.ClassCastException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.*;
import java.util.Map.Entry;

public class SimPreciseInv extends PreciseInv implements Obj2Bytes, IrisSerializable{

  final AcceptVV dvv;
  //final Object data;
  protected IrisObject data;
  final public TreeSet<Byte> flags;
  final protected TreeSet<Hash> objectHashes;
  final protected boolean delete;

  final static boolean useHopCount = false;
  int hopCount = -1;

  public SimPreciseInv(){
    dvv = null;
    //data = null;
    data = null;
    flags = new TreeSet();
    objectHashes = new TreeSet<Hash>();
    delete = false;
  }

  public SimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, IrisObject data, TreeSet<Hash> objectHashes, boolean _delete){
    super(new ObjInvalTarget(obj_, 0, 1), acceptStamp_, acceptStamp_, false);
    this.dvv = dvv;
    this.data = data;
    //    this.databytes = serialize(data);
    if(useHopCount){
      hopCount = 0;
    }
    flags = new TreeSet();
    this.objectHashes = new TreeSet<Hash>();
    this.objectHashes.addAll(objectHashes);
    this.delete = _delete;
  }

  //  protected SimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, IrisObject data, TreeSet<Hash> objectHashes, boolean _delete){
  //    super(new ObjInvalTarget(obj_, 0, 1), acceptStamp_, acceptStamp_, false);
  //    this.dvv = dvv;
  //    this.data = data;
  ////    this.databytes = databytes;
  //    flags = new TreeSet();
  //    this.objectHashes = new TreeSet<Hash>();
  //    this.objectHashes.addAll(objectHashes);
  //    this.delete = _delete;
  //  }

  protected SimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, IrisObject data, boolean embargoed,
      TreeSet flags, TreeSet<Hash> objectHashes, boolean _delete){
    super(new ObjInvalTarget(obj_, 0, 1), acceptStamp_, acceptStamp_, embargoed);
    this.dvv = dvv;
    this.data = data;
    //    this.databytes = serialize(data);
    this.flags = flags;
    this.objectHashes = new TreeSet<Hash>();
    this.objectHashes.addAll(objectHashes);
    this.delete = _delete;
  }

  public SimPreciseInv cloneWithNewNodeId(NodeId newId){
    SimPreciseInv ret = new SimPreciseInv(this.obj.getObjId(), 
        new AcceptStamp(super.acceptStamp.getLocalClock(),newId), 
        this.dvv, 
        this.data, 
        objectHashes, delete);    
    ret.flags.addAll(this.flags);
    return ret;
  }

  public int getEpoch(){
    return 0;
  }

  @SuppressWarnings("unchecked")
  public byte[] obj2Bytes(){
    try{
      SerializationHelper serHelper = new SerializationHelper();
      ObjectOutput oos = serHelper.getObjectOutputStream();

      oos.writeLong(this.getAcceptStamp().getLocalClock());
      oos.writeLong(this.getAcceptStamp().getNodeId().getIDint());
      serHelper.close();
      return serHelper.toBytes();
    }catch(Exception e){
      e.printStackTrace();
    }
    assert false;
    return null;

  }

  public Hash generateMyHash(){
    return Hash.createHash(this.getAcceptStamp());
  }

  public Hash getHash(){
    return Hash.NullHash;
  }


  public boolean verifySig(){
    return true;
  }

  public Hash getHash(NodeId n) throws NoSuchEntryException {
    throw new NoSuchEntryException("Operating in insecure mode");
  }

  //  protected SimPreciseInv(ObjId obj_, AcceptStamp acceptStamp_, AcceptVV dvv, byte[] databytes, 
  //      boolean embargoed, TreeSet<Hash> objectHashes, boolean _delete){
  //    super(new ObjInvalTarget(obj_, 0, 1), acceptStamp_, acceptStamp_, embargoed);
  //    this.dvv = dvv;
  //    //this.data = data;
  //    this.databytes = databytes;
  //    flags = new TreeSet();
  //    this.objectHashes = new TreeSet<Hash>();
  //    this.objectHashes.addAll(objectHashes);
  //    this.delete = _delete;
  //  }

  public IrisObject getData(){
    return data;
    //    return deserilize(databytes);
  }

  public void replaceIrisObject(IrisObject newObj){
    if(newObj.getHash().equals(data.getHash())){
      assert !(this.getObjId().getPath().startsWith(SangminConfig.gcProposalDir) || this.getObjId().getPath().startsWith(SangminConfig.bodyAttachDir));
      data = newObj;
    }
  }

  public int hashCode(){    
    //return dvv.hashCode() + data.hashCode() + this.acceptStamp.hashCode() + new Long(this.getStart()).hashCode() + this.obj.hashCode();
    return dvv.hashCode() + data.hashCode() + //Arrays.hashCode(databytes) + 
    this.acceptStamp.hashCode() + new Long(this.getStart()).hashCode() + this.obj.hashCode() + flags.hashCode() + objectHashes.hashCode();
  }

  public int compareTo(Object o) throws ClassCastException{
    return super.compareTo(o);
  }

  public boolean equals(Object o){
    if(!equalsIgnoringFlags(o)){
      return false;
    }else{
      return flags.equals(((SimPreciseInv)o).getFlags());
    }
  }

  public boolean equalsIgnoreBranches(SimPreciseInv spi){
    assert !Node.enableSecurity;
    return this.equals(spi);
  }

  /**
   * Update oldId of dvv to newId if the oldId's time stamp is greater 
   * than or equal to timestamp 
   * @param oldId NodeId to be updated
   * @param timestmp
   * @param newId new NodeId
   * @return true if this dvvMap has oldId component to be updated,
   *  false otherwise
   */
  public SimPreciseInv updateDVV(POMRemap remap){
    return this;
  }

  public boolean equalsIgnoringFlags(Object o){
    if(!(o instanceof SimPreciseInv)){
      return false;
    }else{
      SimPreciseInv spi = (SimPreciseInv)o;
      //return super.equals(o) && dvv.equals(spi.dvv) && data.equals(spi.data);
      boolean ret = super.equals(o) && dvv.equals(spi.dvv) && 
      //      Arrays.equals(this.databytes, spi.databytes) && 
      this.data.getHash().equals(spi.data.getHash()) && 
      objectHashes.equals(spi.objectHashes) ;
      return ret && delete == spi.delete;
    }
  }
  //  public boolean equalsIgnoreBranches(SimPreciseInv spi){
  //    return data.equals(spi.data) && this.getObjId().equals(spi.getObjId()) && 
  //    (this.getNodeId().getIDint() == spi.getNodeId().getIDint()) && this.dvv.equalsIgnoreBranches(spi.dvv); 
  //  }

  public String toString(){
    //return acceptStamp.toString() + " DVV:" + dvv + " data: " + data;
    return acceptStamp.toString() + " DVV:" + dvv + " data: " + data + 
    //    deserilize(databytes) + 
    " Flags" + this.flags + "obj hashes : " + objectHashes + " delete :" + delete;
  }

  public AcceptVV getDVV(){
    return dvv;
  }

  public TreeSet getFlags(){
    return flags;
  }

  public TreeSet<Hash> getObjectHashes(){
    return objectHashes;
  }

  public SimPreciseInv applyBranchMap(HashMap<NodeId, NodeId> branchMap){
    AcceptStamp as;
    if(branchMap.containsKey(acceptStamp.getNodeId())){
      as = new AcceptStamp(super.acceptStamp.getLocalClock(), branchMap.get(super.acceptStamp.getNodeId()));
    }else{
      as = super.acceptStamp;
    }
    SimPreciseInv ret = new SimPreciseInv(this.obj.getObjId(), 
        as, 
        this.dvv.applyBranchMap(branchMap), 
        this.data, objectHashes, 
        this.delete);    
    ret.flags.addAll(this.flags);
    return ret;
  }

  public boolean isDelete(){
    return delete;
  }

  public void readExternal(ObjectInput in) 
  throws IOException, ClassNotFoundException{

    String str = SerializationHelper.readShortString(in);
    ObjId objId = new ObjId(str);

    AcceptStamp as = new AcceptStamp();
    as.readExternal(in);

    AcceptVV _vv = new AcceptVV();
    //    byte[] sig = null;
    //    if(Node.useSignature){
    //      int sigSize = in.readInt();
    //      sig = new byte[sigSize];
    //      in.readFully(sig);
    //    }
    boolean _delete = in.readBoolean();
    IrisObject data;
    if(_delete){
      data = Store.deleteObject;
    }else{
      if(SangminConfig.separateBodies && !(str.startsWith(AgreementGCProtocol.gcProposalDir))){
        byte[] hass = new byte[Hash.Length];
        in.readFully(hass);
        data = new IrisHashObject(new Hash(hass, false));
      }else{
        //        data = (IrisObject)in.readObject();
        short len = in.readShort();
        byte[] dataArr = new byte[len];
        in.readFully(dataArr);
        data = new IrisDataObject(dataArr);
      }
    }

    int size = in.readByte();
    TreeSet<Hash> _objHashes = new TreeSet<Hash>();
    for(int i = 0; i < size; i++){
      byte[] _hash = new byte[Hash.Length];
      in.readFully(_hash);
      _objHashes.add(new Hash(_hash, false));
    }


    int hopcount=-1;
    if(SimPreciseInv.useHopCount){
      hopcount = in.readInt();
    }

    Field[] f = new Field[10];

    try{

      f[0] = PreciseInv.class.getDeclaredField("obj");
      f[1] = PreciseInv.class.getDeclaredField("acceptStamp");
      f[2] = PreciseInv.class.getDeclaredField("rtAcceptStamp");
      f[3] = PreciseInv.class.getDeclaredField("embargoed");
      f[4] = PreciseInv.class.getDeclaredField("committed");
      f[5] = SimPreciseInv.class.getDeclaredField("dvv");
      f[6] = SimPreciseInv.class.getDeclaredField("data");
      f[7] = SimPreciseInv.class.getDeclaredField("objectHashes");
      f[8] = SimPreciseInv.class.getDeclaredField("hopCount");
      f[9] = SimPreciseInv.class.getDeclaredField("delete");

    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, new ObjInvalTarget(objId,
          0,
          1));
      f[1].set(this, as);
      f[2].set(this, as);
      f[3].setBoolean(this, false);
      f[4].setBoolean(this, false);
      f[5].set(this, _vv);
      f[6].set(this, data);
      f[7].set(this, _objHashes);
      f[8].set(this, hopcount);
      f[9].set(this, _delete);


    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }

  }

  public void writeExternal(ObjectOutput out) throws IOException{

    SerializationHelper.writeShortString(this.getObjId().getPath(), out);

    this.getAcceptStamp().writeExternal(out);    

    //    if(Node.useSignature){
    //      out.writeInt(signature.length);
    //      out.write(signature);
    //    }
    out.writeBoolean(delete);
    if(!delete){
      //      out.writeObject(data);
      if(SangminConfig.separateBodies && !(this.getObjId().getPath().startsWith(AgreementGCProtocol.gcProposalDir))){
        out.write(data.getHash().getHashVal());
      }else{
        //        data = (IrisObject)in.readObject();
        assert data instanceof IrisDataObject;
        IrisDataObject ido = (IrisDataObject)data;
        short len = (short)ido.getUnsafeBytes().length;
        out.writeShort(len);
        out.write(ido.getUnsafeBytes());
      }
    }
    out.writeByte(objectHashes.size());
    for(Hash h: objectHashes){
      out.write(h.getHashVal());
    }
    if(SimPreciseInv.useHopCount){
      out.writeInt(hopCount);
    }
  }

  public static void testExt() throws IOException{
    String data = "data";
    byte[] bytes = new byte[Hash.Length];
    for(int i=0; i<Hash.Length; i++){
      bytes[i] = 'a';
    }

    Hash hash = new Hash(bytes, false);
    HashMap<NodeId, Hash> hashes = new HashMap<NodeId, Hash>();
    hashes.put(new BranchID(5), hash);

    TreeSet<Hash> objHashes = new TreeSet<Hash>();
    objHashes.add(Hash.NullHash);
    objHashes.add(hash);

    IrisObject irisData = new IrisDataObject(data.getBytes());
    SimPreciseInv sspi = new SimPreciseInv(new ObjId(AgreementGCProtocol.gcProposalDir+"test"), new AcceptStamp(10,new BranchID(10)), 
        new AcceptVV(), irisData , objHashes, false);


    ByteArrayOutputStream bs;
    ObjectOutputStream oos;

    bs = new ByteArrayOutputStream();
    oos = new IrisObjectOutputStream(bs);
    System.out.println("Serialise it");
    //    oos.writeObject(sspi);
    sspi.writeExternal(oos);

    oos.flush();
    //bs.toByteArray();
    System.out.println("read it " + bs.toByteArray().length);
    SimPreciseInv sspi2 = null;
    ObjectInputStream ois = new IrisObjectInputStream(new ByteArrayInputStream(bs.toByteArray()));
    try{
      //      sspi2 = (SecureSimPreciseInv)ois.readObject();
      sspi2 = new SimPreciseInv();
      sspi2.readExternal(ois);
    }catch(ClassNotFoundException e){
      e.printStackTrace();
    }

    if(sspi.equals(sspi2)){
      System.out.println("Success");
    } else {
      System.out.println("Fail : \n" + sspi + "\n" + sspi2);

      assert sspi.data.equals(sspi2.data);
      if(Node.enableSecurity){
        assert sspi.dvv.equals(sspi2.dvv);

      }
    }
  }

  public static void testStr() throws IOException{
    String data = "data";
    byte[] bytes = new byte[Hash.Length];
    for(int i=0; i<Hash.Length; i++){
      bytes[i] = 'a';
    }

    Hash hash = new Hash(bytes, false);
    HashMap<NodeId, Hash> hashes = new HashMap<NodeId, Hash>();
    hashes.put(new BranchID(5), Hash.NullHash);

    TreeSet<Hash> objHashes = new TreeSet<Hash>();
    objHashes.add(Hash.NullHash);
    objHashes.add(hash);

    IrisObject irisData = new IrisDataObject(data.getBytes());
    SimPreciseInv sspi = new SimPreciseInv(new ObjId(SangminConfig.bodyAttachDir+"test"), new AcceptStamp(10,new BranchID(10)), 
        new AcceptVV(), irisData , objHashes, false);


    ByteArrayOutputStream bs;
    IrisOutputStream oos;

    bs = new ByteArrayOutputStream();
    oos = new IrisOutputStream(bs);
    System.out.println("Serialise it");
    //    oos.writeObject(sspi);
    sspi.writeToStream(oos, false);

    oos.flush();
    //bs.toByteArray();
    System.out.println("read it " + bs.toByteArray().length);
    SimPreciseInv sspi2 = null;
    IrisInputStream ois = new IrisInputStream(new ByteArrayInputStream(bs.toByteArray()));
    sspi2 = new SimPreciseInv();
    sspi2.readFromStream(ois, false);


    if(sspi.equals(sspi2)){
      System.out.println("Success");
    } else {
      System.out.println("Fail : \n" + sspi + "\n" + sspi2);

      assert sspi.data.equals(sspi2.data);
      if(Node.enableSecurity){
        assert sspi.dvv.equals(sspi2.dvv);

      }
    }
  }

  public static void main(String[] args) throws IOException{
    testExt();
    testStr();    


  }

  public void readFromStream(IrisInputStream in, boolean optimized)
  throws IOException{
    String str = in.readShortString();
    ObjId objId = new ObjId(str);

    AcceptStamp as = new AcceptStamp();
    as.readFromStream(in, false);

    int sz = in.readInt();
    CounterVV cvv = new CounterVV();
    long base = as.getLocalClock();
    for(int i = 0; i < sz; i++){
      AcceptStamp ass = new AcceptStamp();
      ass.readFromStream(in, optimized);
      //BranchID nodeId = new BranchID(in.readLong());
      //long ts = base-in.readLong();
      //assert ts >= 0:ts;
      //cvv.advanceTimestamps(new AcceptStamp(ts, nodeId));
      cvv.advanceTimestamps(ass);
    }
    AcceptVV _vv = new AcceptVV(cvv);
    //    byte[] sig = null;
    //    if(Node.useSignature){
    //      int sigSize = in.readInt();
    //      sig = new byte[sigSize];
    //      in.readFully(sig);
    //    }
    boolean _delete = in.readBoolean();
    IrisObject data;
    if(_delete){
      data = Store.deleteObject;
    }else{
      if(SangminConfig.separateBodies && 
          !(str.startsWith(AgreementGCProtocol.gcProposalDir) || str.startsWith(SangminConfig.bodyAttachDir))){
        byte[] hass = new byte[Hash.Length];
        in.readFully(hass);
        data = new IrisHashObject(new Hash(hass, false));
      }else{
        //        data = (IrisObject)in.readObject();
        short len = in.readShort();
        byte[] dataArr = new byte[len];
        in.readFully(dataArr);
        data = new IrisDataObject(dataArr);
      }
    }

    int size = in.readByte();
    TreeSet<Hash> _objHashes = new TreeSet<Hash>();
    for(int i = 0; i < size; i++){
      byte[] _hash = new byte[Hash.Length];
      in.readFully(_hash);
      _objHashes.add(new Hash(_hash, false));
    }


    int hopcount=-1;
    if(SimPreciseInv.useHopCount){
      hopcount = in.readInt();
    }

    Field[] f = new Field[10];

    try{

      f[0] = PreciseInv.class.getDeclaredField("obj");
      f[1] = PreciseInv.class.getDeclaredField("acceptStamp");
      f[2] = PreciseInv.class.getDeclaredField("rtAcceptStamp");
      f[3] = PreciseInv.class.getDeclaredField("embargoed");
      f[4] = PreciseInv.class.getDeclaredField("committed");
      f[5] = SimPreciseInv.class.getDeclaredField("dvv");
      f[6] = SimPreciseInv.class.getDeclaredField("data");
      f[7] = SimPreciseInv.class.getDeclaredField("objectHashes");
      f[8] = SimPreciseInv.class.getDeclaredField("hopCount");
      f[9] = SimPreciseInv.class.getDeclaredField("delete");

    }catch(NoSuchFieldException ne){
      System.err.println(ne.toString());
      ne.printStackTrace();
      System.exit(-1);
    }
    try{
      AccessibleObject.setAccessible(f, true);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
    try{
      f[0].set(this, new ObjInvalTarget(objId,
          0,
          1));
      f[1].set(this, as);
      f[2].set(this, as);
      f[3].setBoolean(this, false);
      f[4].setBoolean(this, false);
      f[5].set(this, _vv);
      f[6].set(this, data);
      f[7].set(this, _objHashes);
      f[8].set(this, hopcount);
      f[9].set(this, _delete);


    }catch(IllegalArgumentException ie){
      System.err.println(ie.toString());
      ie.printStackTrace();
      System.exit(-1);
    }catch(IllegalAccessException iae){
      System.err.println(iae.toString());
      iae.printStackTrace();
      System.exit(-1);
    }

    try{
      AccessibleObject.setAccessible(f, false);
    } catch (SecurityException se){
      System.err.println(se.toString());
      se.printStackTrace();
      System.exit(-1);
    }
  }

  public void writeToStream(IrisOutputStream out, boolean optimized)
  throws IOException{
    out.writeShortString(this.getObjId().getPath());

    this.getAcceptStamp().writeToStream(out, optimized);    

    //    if(Node.useSignature){
    //      out.writeInt(signature.length);
    //      out.write(signature);
    //    }
    Collection<AcceptStamp> stamps  = dvv.getAllStamps();
    out.writeInt(stamps.size());
    long base = this.getAcceptStamp().getLocalClock();
    for(AcceptStamp as: stamps){
      as.writeToStream(out,optimized);
      //out.writeLong(as.getNodeId().getIDint());
      //long ts = base-as.getLocalClock();
      //assert ts > 0: ts;
      //out.writeLong(ts);
    }
    
    out.writeBoolean(delete);
    if(!delete){
      //      out.writeObject(data);
      if(SangminConfig.separateBodies && 
          !(this.getObjId().getPath().startsWith(AgreementGCProtocol.gcProposalDir) || this.getObjId().getPath().startsWith(SangminConfig.bodyAttachDir))){
        out.write(data.getHash().getHashVal());
      }else{
        //        data = (IrisObject)in.readObject();
        assert data instanceof IrisDataObject;
        IrisDataObject ido = (IrisDataObject)data;
        short len = (short)ido.getUnsafeBytes().length;
        out.writeShort(len);
        out.write(ido.getUnsafeBytes());
      }
    }
    out.writeByte(objectHashes.size());
    for(Hash h: objectHashes){
      out.write(h.getHashVal());
    }
    if(SimPreciseInv.useHopCount){
      out.writeInt(hopCount);
    }
  }

  /*

  public void writeExternal(ObjectOutput out) throws IOException{


    out.writeObject(this.getObjId().getPath());
    out.writeLong(this.getOffset());
    out.writeLong(this.getLength());
    out.writeLong(this.getAcceptStamp().getLocalClock());
    //System.out.println("WRITE getRTAcceptStamp : " + this.getAcceptStamp().getLocalClock());
    if(SangminConfig.forkjoin){
      out.writeObject(getAcceptStamp().getNodeId());
    } else {
      if(SangminConfig.compressNodeId){
        out.writeByte((int)getAcceptStamp().getNodeId().getIDint());
      }else{
        out.writeLong(getAcceptStamp().getNodeId().getIDint());
      }
    }
    // realtime AcceptStamp & embargoed flag for tact/embargoed write
    out.writeLong(this.getRTAcceptStamp().getLocalClock());
    out.writeBoolean(this.isEmbargoed());


    // security components
    if(SangminConfig.securityLevel >= SangminConfig.COMPLETE){
      if(SangminConfig.compressNodeId){
        out.writeByte(dvv.getSize());
      }else{
        out.writeInt(dvv.getSize());
      }
      //System.out.println("WRITE numNodesInDVV : " + dvv.getSize());
      for( Enumeration<NodeId> enu = dvv.getEnumeratedNodes(); enu.hasMoreElements();){
        try{
          NodeId nodeId = (NodeId)enu.nextElement();
          if(SangminConfig.forkjoin){            
            out.writeObject(nodeId);
          } else {
            if(SangminConfig.compressNodeId){
              out.writeByte((int)nodeId.getIDint());
            }else{
              out.writeLong(nodeId.getIDint());
            }       
          }
          out.writeLong(dvv.getStampByServer(nodeId));                               
        }catch(Exception e){
          e.printStackTrace();
          System.exit(-1);
        }
      }

      if(hasHash){
      assert(sh.getValue().length == Hash.Length);
      out.write(sh.getValue());
      }
    }
    assert(dh.getHashVal().length == Hash.Length);
    out.write(dh.getHashVal());
    if(hasHash){
      assert(signature.length>=0):signature.length;
      out.writeInt(signature.length);
      out.write(signature);
    }
    out.writeInt(hops);
    if(SecurityFilter.debugSerialization){
      out.writeByte(SecurePreciseInv.classCode);
    }
  }*/
}
