package code.simulator;

import java.util.Collection;

import code.AcceptStamp;
import code.simulator.log.LogStatus;

public class SyncStatus{

  public static final byte SyncSuccessful = 0;
  public static final byte ReceivedNewCertificate = 1;
  public static final byte DVVInclusionFailed = 2; // same as log
  public static final byte InclusionFailed = 3;
  public static final byte CompatibilityFailed = 4;
  public static final byte SenderFaulty = 5;
  public static final byte SenderOldEpoch = 6;
  public static final byte WriteFromConcurrentBranch = 7;
  public static final byte NetworkError = 8;
  public static final byte SyncFilterReject = 9;
  public static final byte CertFilterReject = 10;
  public static final byte SignatureVerificationFail = 11;
//  public static final byte FIFOFailed = 12;
  public static final byte FIFOPassedInclusionUnverifiable = 13;
  public static final byte WriteToForkedParentBranch = 14;
  public static final byte MissingPOMForForkedChildBranch = 15;
  public static final byte WriteFromForkedNodeWithInvalidBranchHistory = 16;
  public static final byte ImproperLamportClock = 17; 
  public static final byte ImproperEpochNumber = 18; 
  public static final byte ImproperDVV = 19; 
  public static final byte ImproperBranchID = 20; 
  public static final byte EpochChanged = 21; 
  public static final byte OptimizedSyncFailed = 22; // the BranchID of a write that is inconsistent due to checkpoint is incorrect
  public static final byte TimeStampExhaustionCheckFailed = 23;

  private Collection<IrisDataObject> bodies;
  
  
  public byte status;
  public AcceptStamp as; // only relevant for compatibility check failures or inclusion check failures
  
  public SyncStatus(byte status){
    this.status = status;
    bodies = null;
  }
  
  public SyncStatus(byte status, AcceptStamp as){
    this(status);
    this.as = as;
  }
  
  public static SyncStatus makeSyncStatusFromLogStatus(LogStatus ls, AcceptStamp as){
    byte s = 0;
    if(ls.getApplyStatus() == LogStatus.ApplyFailed){
      switch(ls.getVerificationStatus()){
      case LogStatus.DVVInclusionFail: s = SyncStatus.DVVInclusionFailed; break;
      case LogStatus.CompatibilityFail: s = SyncStatus.CompatibilityFailed; break; 
      case LogStatus.InclusionFail: s = SyncStatus.InclusionFailed; break;
//      case LogStatus.FIFOFail: s = SyncStatus.FIFOFailed; break;
      case LogStatus.SignatureVerificationFail: s = SyncStatus.SignatureVerificationFail; break;
      case LogStatus.FIFOPassedInclusionUnverifiable: s = SyncStatus.FIFOPassedInclusionUnverifiable; break;
      case LogStatus.WriteToForkedParentBranch: s = SyncStatus.WriteToForkedParentBranch; break;
      case LogStatus.MissingPOMForForkedChildBranch: s = SyncStatus.MissingPOMForForkedChildBranch; break;
      case LogStatus.WriteFromForkedNodeWithInvalidBranchHistory: s = SyncStatus.WriteFromForkedNodeWithInvalidBranchHistory; break;
      case LogStatus.ImproperLamportClock: s = SyncStatus.ImproperLamportClock; break;
      case LogStatus.ImproperEpochNumber: s = SyncStatus.ImproperEpochNumber; break;
      case LogStatus.ImproperDVV: s = SyncStatus.ImproperDVV; break;
      case LogStatus.ImproperBranchID: s = SyncStatus.ImproperBranchID; break;
      case LogStatus.OptimizedSyncFailed: s = SyncStatus.OptimizedSyncFailed; break;
      case LogStatus.TimeStampExhaustionCheckFailed: s = SyncStatus.TimeStampExhaustionCheckFailed; break;
      default: assert false;
      }
      
      
      return new SyncStatus(s, as);
    }else{
      return new SyncStatus(SyncSuccessful);
    }
  }
  
  public String toString(){
    switch(status){
    case SyncStatus.ReceivedNewCertificate:return "ReceivedNewCertificate";
    case SyncStatus.SenderOldEpoch:return "SenderOldEpoch";
    case SyncStatus.InclusionFailed:return "InclusionFailed" + as;
//    case SyncStatus.FIFOFailed:return "FIFOFailed" + as;
    case SyncStatus.CompatibilityFailed:return "CompatibilityFailed" + as;
    case SyncStatus.SenderFaulty:return "SenderFaulty";
    case SyncStatus.SyncSuccessful:return "SyncSuccessful";
    case SyncStatus.DVVInclusionFailed:return "DVVInclusionFailed" + as;
    case SyncStatus.WriteFromConcurrentBranch:return "WriteFromConcurrentBranch" + as;
    case SyncStatus.NetworkError:return "NetworkError";
    case SyncStatus.SyncFilterReject:return "SyncFilterReject";
    case SyncStatus.CertFilterReject:return "CertFilterReject";
    case SyncStatus.FIFOPassedInclusionUnverifiable: return "FIFOPassedInclusionUnverifiable"; 
    case SyncStatus.WriteToForkedParentBranch: return "WriteToForkedParentBranch"; 
    case SyncStatus.MissingPOMForForkedChildBranch: return "MissingPOMForForkedChildBranch"; 
    case SyncStatus.WriteFromForkedNodeWithInvalidBranchHistory: return "WriteFromForkedNodeWithInvalidBranchHistory"; 
    case SyncStatus.ImproperLamportClock: return "ImproperLamportClock"; 
    case SyncStatus.SignatureVerificationFail:return "SignatureVerificationFail";
    case SyncStatus.ImproperEpochNumber:return "ImproperEpochNumber";
    case SyncStatus.ImproperDVV:return "ImproperDVV";
    case SyncStatus.ImproperBranchID:return "ImproperBranchID";
    case SyncStatus.EpochChanged:return "EpochChanged";
    case SyncStatus.OptimizedSyncFailed:return "OptimizedSyncFailed";
    case SyncStatus.TimeStampExhaustionCheckFailed:return "TimeStampExhaustionCheckFailed";
    default: return "Invalid Sync Status";
    }
  }

  /**
   * @return the bodies
   */
  public Collection<IrisDataObject> getBodies(){
    return bodies;
  }

  /**
   * @param bodies the bodies to set
   */
  public void setBodies(Collection<IrisDataObject> bodies){
    this.bodies = bodies;
  }
  
}
