package code.simulator.agreement;

import java.util.Collection;
import java.util.LinkedList;

public class AgreementParams{
  final private int numNodes;
  final private int numFailures;
  final private long myID; 
  final Collection<Long> allNodes;
  
  public AgreementParams(int numN, int numF, long myID, final Collection<Long> allNodes){
    this.numNodes = numN;
    this.numFailures = numF;
    this.myID = myID;
    this.allNodes = new LinkedList<Long>();
    this.allNodes.addAll(allNodes);
  }

  public int getNumNodes(){
    return numNodes;
  }

  public int getNumFailures(){
    return numFailures;
  }

  public int weakQuorum(){
    return numNodes-3*numFailures;
  }
  
  public int strongQuorum(){
    return numNodes-numFailures;
  }

  public long getMyID(){
    return myID;
  }
  
  public Collection<Long> allNodes(){
    return allNodes;
  }

  @Override
  public String toString(){
    return "AgreementParams [allNodes=" + allNodes + ", myID=" + myID
        + ", numFailures=" + numFailures + ", numNodes=" + numNodes + "]";
  }
}
