package code.simulator.agreement;

import code.NodeId;
import code.SubscriptionSet;
import code.simulator.NamespaceWatch;

import java.util.HashMap;
import java.util.LinkedList;

/**
 * Implements a FIFO reliable communication channel for sending and receiving messages.
 * 
 * Broadcast: Messages successfully acknowledged at correct senders are guaranteed to be eventually delivered 
 * in FIFO order to all correct receivers
 * 
 * After recovering from a crash, applications must poll to check if any new messages were received.
 * Applications are responsible for guarding against duplicates. 
 *  
 * @author princem
 *
 */
public interface CommunicationChannel{

  public void broadcast(Object o);
 
  public void addNamespaceWatch(NamespaceWatch mr, SubscriptionSet ss);
}
