package code.simulator.agreement;

import java.io.Serializable;

public abstract class DecisionProof implements Serializable{

  final InstanceID instanceID;
  public DecisionProof(InstanceID instanceID){
    this.instanceID = instanceID;
  }

  abstract public boolean verify();

  public InstanceID getInstanceID(){
    return instanceID;
  }

  @Override
  public String toString(){
    return "DecisionProof [instanceID=" + instanceID + "]";
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result
        + ((instanceID == null) ? 0 : instanceID.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof DecisionProof)){
      return false;
    }
    DecisionProof other = (DecisionProof) obj;
    if(instanceID == null){
      if(other.instanceID != null){
        return false;
      }
    }else if(!instanceID.equals(other.instanceID)){
      return false;
    }
    return true;
  }

}
