package code.simulator.agreement;

import java.io.ObjectOutput;
import java.io.Serializable;

import code.serialization.SerializationHelper;
import code.simulator.Obj2Bytes;

public class InstanceID implements Serializable, Comparable<InstanceID>, Obj2Bytes{
  public static final long NullNode = -1;
  
  public static final byte NullPhase = -1;
  public static final byte OmitVVAgreement = 0;
  public static final byte EndVVAgreement = 1;
  public static final byte CheckpointAgreement = 2;

  final private int epoch;
  final private byte phase; // first phase for deciding omitVV in GC and whether we are executing eviction of given node in the next phase
  //strategy: preference always given to checkpoint


  final private long nodeId;
  
  /**
   * @param epoch
   * @param phase
   * @param nodeId
   */
  public InstanceID(int epoch, byte phase, long nodeId){
    this.epoch = epoch;
    this.phase = phase;
    this.nodeId = nodeId;
  }
  
  /**
   * @param epoch
   * @param phase
   * @param nodeId
   */
  public InstanceID(int epoch, byte phase){
    this.epoch = epoch;
    this.phase = phase;
    this.nodeId = NullNode;
  }

  public static String phaseString(byte phase){
    switch(phase){
    case InstanceID.NullPhase: return "NullPhase";
    case InstanceID.OmitVVAgreement: return "OmitVVAgreement";
    case InstanceID.EndVVAgreement: return "EndVVAgreement";
    case InstanceID.CheckpointAgreement: return "CheckpointAgreement";
    default:assert false;
    }
    return "ERROR";
  }
  @Override
  public String toString(){
    return "InstanceID [epoch=" + epoch + ", nodeId=" + nodeId + ", phase="
        + this.phaseString(phase) + "]";
  }

  public int getEpoch(){
    return epoch;
  }

  public byte getPhase(){
    return phase;
  }

  public long getNodeId(){
    return nodeId;
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + epoch;
    result = prime * result + (int) (nodeId ^ (nodeId >>> 32));
    result = prime * result + phase;
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof InstanceID)){
      return false;
    }
    InstanceID other = (InstanceID) obj;
    if(epoch != other.epoch){
      return false;
    }
    if(nodeId != other.nodeId){
      return false;
    }
    if(phase != other.phase){
      return false;
    }
    return true;
  }

  public int compareTo(InstanceID o){
    // TODO Auto-generated method stub
    if(epoch < o.epoch){
      return -1;
    }else if(epoch > o.epoch){
      return 1;
    }else if(phase < o.phase){
      return -1;
    }else if(phase > o.phase){
      return 1;
    }else if(this.nodeId < o.nodeId){
      return -1;
    }else if(this.nodeId > o.nodeId){
      return 1;
    }else{
      return 0;
    }
  }

  public byte[] obj2Bytes(){
    
    try{
      SerializationHelper serHelper = new SerializationHelper();
      ObjectOutput oos = serHelper.getObjectOutputStream();
      oos.writeInt(epoch);
      oos.writeLong(nodeId);
      oos.writeByte(phase);
      return serHelper.toBytes();
    } catch(Exception e){
      e.printStackTrace();
    }
    assert false;
    return null;    
    
  }
  
  
}
