package code.simulator.agreement;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.TreeSet;

import code.simulator.protocolFilters.AgreementGCProtocol;

public class ListAgreementInstance implements AgreementMonitor, AgreementInterface{

  private final InstanceID instanceID;
  private final HashMap<Long, AgreementInstance> instanceMap;
  private final TreeSet<Long> localVotes;
  private final TreeSet<Long> initialVotes;
  private final HashMap<Long, DecisionProof> decisionMap;
  private final AgreementMonitor controller; 
  private boolean timedOut = false;
  private boolean decided = false;
  public static final boolean print = true;

  public ListAgreementInstance(InstanceID instanceID, AgreementMonitor c){
    this.instanceID = instanceID;
    assert instanceID.getNodeId() == InstanceID.NullNode;
    instanceMap = new HashMap<Long, AgreementInstance>();
    localVotes = new TreeSet<Long>();
    initialVotes = new TreeSet<Long>();
    decisionMap = new HashMap<Long, DecisionProof>();
    this.controller = c;

//    TimerTask task = new TimerTask(){
//      public void run(){
//        if(print)if(AgreementInstance.debug)System.out.println("Starting list timer at " + controller.getParams().getMyID());
//        timedOut = true; 
//        voteBottomForMissingVotes();
//
//      }
//    };
//    AgreementInstance.timer.schedule(task, controller.getTimeOut());

  }
  synchronized public void notifyTimeout(){
    if(decided){
      return;
    }else{
      if(AgreementInstance.debug)System.out.println(this.getParams().getMyID() + " returning from timeout because DECIDED");
    }
    if(!timedOut){
      timedOut = true;
      this.voteBottomForMissingVotes();
    }else{
      if(AgreementInstance.debug)System.out.println(this.getParams().getMyID() + " returning from timeout because TIMEDOUT");
    }
    
    LinkedList<AgreementInstance> ais = new LinkedList<AgreementInstance>();
    ais.addAll(this.instanceMap.values());
    for(AgreementInstance ai: ais){
      ai.notifyTimeout();
    }
  }
  
  synchronized public void notifyDecision(InstanceID instanceID, DecisionProof proof){
    // TODO Auto-generated method stub
    assert proof instanceof ValueDecisionProof;
    if(decided){
      return;
    }
    ValueDecisionProof dp = (ValueDecisionProof)proof;
    if(dp.verify()){
      decisionMap.put(dp.getInstanceID().getNodeId(), dp);
      if(decisionMap.size() == controller.getParams().getNumNodes()){
        decided = true;
        controller.notifyDecision(instanceID, controller.getVoteFactory().getDecisionProof(instanceID, decisionMap));
        if(AgreementInstance.debug)System.out.println(this.controller.getParams().getMyID() + " LIST DECISION ");
      }else if(decisionMap.size() == controller.getParams().weakQuorum() && timedOut){
        this.voteBottomForMissingVotes();
      }else{
        if(AgreementInstance.debug)System.out.println(this.controller.getParams().getMyID() + " received " + decisionMap.size() + " " + decisionMap.keySet() + "decisions ... waiting to get " + controller.getParams().getNumNodes());
      }
    }
  }

  /**
   * process a new vote
   */
  synchronized public void receiveVote(long sender, Vote v){
    assert v.getInstanceID().getEpoch() == this.getInstanceID().getEpoch();
    assert v.getInstanceID().getPhase() == this.getInstanceID().getPhase();
    assert v.getInstanceID().getNodeId() != InstanceID.NullNode;
    if(v.getRound() == 0 && !instanceMap.containsKey(v.getInstanceID().getNodeId())){
      AgreementInstance ai = new AgreementInstance(v.getInstanceID(), this);
      instanceMap.put(v.getInstanceID().getNodeId(), ai);
    }else{
      // this assert can be violated in truly faulty scenario when faulty nodes sends round 2 votes without sending round 1 vote 
      assert instanceMap.containsKey(v.getInstanceID().getNodeId());
    }
    if(instanceMap.containsKey(v.getInstanceID().getNodeId())){
      instanceMap.get(v.getInstanceID().getNodeId()).receiveVote(sender, v);
    }
    if(sender == v.getInstanceID().getNodeId()){
      initialVotes.add(sender);
    }
    if(v.getRound() == 0 && !localVotes.contains(v.getInstanceID().getNodeId()) && 
        (!v.isBottom() || sender == this.getParams().getMyID())){
      localVotes.add(v.getInstanceID().getNodeId());
      if(sender != this.getParams().getMyID()){
        instanceMap.get(v.getInstanceID().getNodeId()).receiveVote(controller.getParams().getMyID(), v);
      }
    }    
  }

  synchronized private void voteBottomForMissingVotes(){
    if(decided){
      return;
    }
    if((initialVotes.size() >= controller.getParams().strongQuorum() && timedOut)){
      // vote bottom for all other values
      for(Long l: controller.getParams().allNodes()){
        if(!localVotes.contains(l)){
          InstanceID newInstance = new InstanceID(this.instanceID.getEpoch(), instanceID.getPhase(), l);
          Vote v = controller.getVoteFactory().getBottomVote(0, newInstance);
          receiveVote(controller.getParams().getMyID(), v);
          this.controller.getChannel().broadcast(v);
          if(AgreementInstance.debug)System.out.println(controller.getParams().getMyID() + " voted " + v);
        }
      }
    }
  }

  public CommunicationChannel getChannel(){
    // TODO Auto-generated method stub
    return controller.getChannel();
  }

  public AgreementParams getParams(){
    // TODO Auto-generated method stub
    return controller.getParams();
  }

  public long getTimeOut(){
    // TODO Auto-generated method stub
    return controller.getTimeOut();
  }

  public VoteFactory getVoteFactory(){
    // TODO Auto-generated method stub
    return controller.getVoteFactory();
  }

  public InstanceID getInstanceID(){
    // TODO Auto-generated method stub
    return this.instanceID;
  }

  synchronized public void receiveDecisionProof(DecisionProof dp){
    // TODO Auto-generated method stub
    if(decided){
      return;
    }
    if(dp instanceof ListDecisionProof){
      if(AgreementInstance.debug)System.out.println(this.controller.getParams().getMyID() + "------ received list decision proof ------");
      assert dp instanceof ListDecisionProof: dp;
    ListDecisionProof ldp = (ListDecisionProof)dp;
    for(DecisionProof dp1: ldp.proofs){
      if(instanceMap.containsKey(dp1.getInstanceID())){
        instanceMap.get(dp1).receiveDecisionProof(dp1);
      }
    }
    decided = true;
    }else{
      if(AgreementInstance.debug)System.out.println(this.controller.getParams().getMyID() + "------ received value decision proof ------" + dp);
      assert(dp.getInstanceID().getEpoch() == this.getInstanceID().getEpoch() && dp.getInstanceID().getPhase() == this.getInstanceID().getPhase());
      assert dp.getInstanceID().getNodeId() != InstanceID.NullNode;
      if(!instanceMap.containsKey(dp.getInstanceID().getNodeId())){
        AgreementInstance ai = new AgreementInstance(dp.getInstanceID(), this);
        instanceMap.put(dp.getInstanceID().getNodeId(), ai);
      }
      instanceMap.get(dp.getInstanceID().getNodeId()).receiveDecisionProof(dp);
      this.notifyDecision(dp.getInstanceID(), dp);
    }
  }

  synchronized public boolean isTimedOut(){
    // TODO Auto-generated method stub
    return this.timedOut;
  }

  @Override
  public String toString(){
    return "ListAgreementInstance [\ndecided=" + decided + ", \ndecisionMap="
        + decisionMap + ", \ninstanceID=" + instanceID + ", \ninstanceMap="
        + instanceMap + ", \nlocalVotes=" + localVotes +  ", \ninitialVotes=" + initialVotes + ", \ntimedOut=" + timedOut
        + "]";
  }

}
