package code.simulator.agreement;

import java.util.Collection;
import java.util.HashMap;

public class ListDecisionProof extends DecisionProof{

  final Collection<DecisionProof> proofs;
  public ListDecisionProof(InstanceID instanceID, HashMap<Long, DecisionProof> map, AgreementParams params){
    super(instanceID);
    // TODO Auto-generated constructor stub
    proofs = map.values();
    assert map.size() == params.getNumNodes();
    for(Long l: map.keySet()){
      assert map.get(l) instanceof ValueDecisionProof;
      ValueDecisionProof vdf = (ValueDecisionProof)map.get(l);
      assert vdf.instanceID.getEpoch() == instanceID.getEpoch();
      assert vdf.instanceID.getPhase() == instanceID.getPhase();
      assert vdf.instanceID.getNodeId() == l;
    }
  }

  public final Collection<DecisionProof> getProofs(){
    return proofs;
  }
  
  @Override
  public boolean verify(){
    // TODO Auto-generated method stub
    return true;
  }

  @Override
  public String toString(){
    return "ListDecisionProof [proofs=" + proofs + ", toString()="
        + super.toString() + "]";
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = super.hashCode();
    result = prime * result + ((proofs == null) ? 0 : proofs.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(!super.equals(obj)){
      return false;
    }
    if(!(obj instanceof ListDecisionProof)){
      return false;
    }
    ListDecisionProof other = (ListDecisionProof) obj;
    if(proofs == null){
      if(other.proofs != null){
        return false;
      }
    }else if(!proofs.equals(other.proofs)){
      return false;
    }
    return true;
  }

}
