package code.simulator.agreement;

import java.io.Serializable;
import java.util.Map.Entry;

import code.NodeId;
import code.simulator.Hash;

public class Tuple<K, V> implements Entry<K, V>, Comparable{

  final K k;
  final V v;
  
  public Tuple(K k, V v){
    this.k = k;
    this.v = v;
  }
  
  public Tuple(Entry<K, V> e){
    this.k = e.getKey();
    this.v = e.getValue();
  }

  public K getKey(){
    return k;
  }

  public V getValue(){
    return v;
  }

  public V setValue(V value){
    assert false;
    return null;
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + ((k == null) ? 0 : k.hashCode());
    result = prime * result + ((v == null) ? 0 : v.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof Tuple)){
      return false;
    }
    Tuple other = (Tuple) obj;
    if(k == null){
      if(other.k != null){
        return false;
      }
    }else if(!k.equals(other.k)){
      return false;
    }
    if(v == null){
      if(other.v != null){
        return false;
      }
    }else if(!v.equals(other.v)){
      return false;
    }
    return true;
  }

  @Override
  public String toString(){
    return "Tuple [k=" + k + ", v=" + v + "]";
  }

  public int compareTo(Object o) throws ClassCastException{
    if(!(o instanceof Tuple)){
      throw new ClassCastException("invalid class comparison: tuple vs " +o);
    }
    Tuple<K, V> t = (Tuple<K, V>)o;
    if(!(k instanceof Comparable)){
      throw new ClassCastException("K is not comparable"+ k);
    }
    int ret = ((Comparable)k).compareTo(t.k);
    if(ret != 0){
      return ret;
    }else{
      if(v instanceof Comparable){
        return ((Comparable) v).compareTo(t.v);
      }else{
        throw new ClassCastException("V is not comparable"+ v);
      }
    }
  }

}
