package code.simulator.agreement;

import java.util.LinkedList;

public class ValueDecisionProof extends DecisionProof{

  final Vote vote;
  public ValueDecisionProof(InstanceID instanceID, LinkedList<Vote> votes, AgreementParams params){
    super(instanceID);
    // TODO Auto-generated constructor stub
    assert votes.size() >= params.strongQuorum();
    assert votes.size() > 0;
    vote  = votes.getFirst();
    
    for(Vote v: votes){
      assert v.equals(vote);
    }
  }

  public Vote getDecidedValue(){
    // TODO Auto-generated method stub
    return vote;
  }

  @Override
  public boolean verify(){
    // TODO Auto-generated method stub
    return true;
  }

  @Override
  public String toString(){
    return "ValueDecisionProof [vote=" + vote + ", toString()="
        + super.toString() + "]";
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = super.hashCode();
    result = prime * result + ((vote == null) ? 0 : vote.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(!super.equals(obj)){
      return false;
    }
    if(!(obj instanceof ValueDecisionProof)){
      return false;
    }
    ValueDecisionProof other = (ValueDecisionProof) obj;
    if(vote == null){
      if(other.vote != null){
        return false;
      }
    }else if(!vote.equals(other.vote)){
      return false;
    }
    return true;
  }

}
