/**
 * 
 */
package code.simulator.agreement;

import java.io.ObjectOutput;
import java.io.Serializable;

import code.Immutable;
import code.serialization.SerializationHelper;
import code.simulator.Obj2Bytes;

/**
 * @author princem
 *
 */
public class Vote<E extends Comparable & Obj2Bytes> implements Immutable, Serializable, Obj2Bytes, Comparable<Vote>{

  final protected InstanceID instanceID;
  final protected int round;
  final protected E data;
  
  public Vote(InstanceID instanceID, int round, E data){
    this.instanceID = instanceID;
    this.round = round;
    this.data = data;
  }
  
  public Vote(InstanceID instanceID, int round){
    this.instanceID = instanceID;
    this.round = round;
    data = null;
  }
  
  public InstanceID getInstanceID(){
    return instanceID;
  }
  
  public int getRound(){
    return this.round;
  }
  
  public E getData(){
    return data;
  }
  
  public boolean isBottom(){
    // TODO Auto-generated method stub
    return (data == null);
  }
    
  public int compareTo(Vote o) {
    // TODO Auto-generated method stub
    int ret = 0;
    if(!(o instanceof Vote)){
      throw new ClassCastException("invalid types compared this:" + this + " o " + o);
    }
    ret = instanceID.compareTo(o.getInstanceID());
    if(ret != 0){
      return ret;
    }else{
      ret = new Integer(round).compareTo(o.getRound());
      if(ret != 0){
        return ret;
      }else{
        if(data == null){
          if(o.data == null){
            return 0;
          }else{
            return -1;
          }
        }else if(o.data == null){
          return 1;
        }else{
          return data.compareTo(o.data);
        }
      }
    }
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + ((data == null) ? 0 : data.hashCode());
    result = prime * result
        + ((instanceID == null) ? 0 : instanceID.hashCode());
    result = prime * result + round;
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof Vote)){
      return false;
    }
    Vote other = (Vote) obj;
    if(data == null){
      if(other.data != null){
        return false;
      }
    }else if(!data.equals(other.data)){
      return false;
    }
    if(instanceID == null){
      if(other.instanceID != null){
        return false;
      }
    }else if(!instanceID.equals(other.instanceID)){
      return false;
    }
    if(round != other.round){
      return false;
    }
    return true;
  }

  @Override
  public String toString(){
    return "Vote [data=" + (data!=null?data:"BOTTOM") + ", " + instanceID + ", round="
        + round + "]";
  }

  public byte[] obj2Bytes(){
    try{
      SerializationHelper serHelper = new SerializationHelper();
      ObjectOutput oos = serHelper.getObjectOutputStream();
      if(data != null){
        oos.write(data.obj2Bytes());
      }
      oos.writeObject(instanceID);
      oos.writeInt(this.round);
      serHelper.close();
      return serHelper.toBytes();
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    assert false;
    return null;
  }

}
