package code.simulator.agreement;

import java.util.HashMap;
import java.util.LinkedList;

public class VoteFactory{
  
  final private AgreementParams params;
  
  public VoteFactory(AgreementParams params){
    this.params = params;
  }

  public static Vote getBottomVote(int round, InstanceID instanceID){
    return new Vote(instanceID, round);
  }
  
  public static Vote createNextRoundVote(Vote v){
    return new Vote(v.getInstanceID(), v.getRound()+1, v.getData());
  }
  
  public static Vote createLocalVote(Vote v){
    return new Vote(v.getInstanceID(), v.getRound(), v.getData());
  }
  
  public DecisionProof getDecisionProof(InstanceID instanceID, LinkedList<Vote> votes){
    return new ValueDecisionProof(instanceID, votes, params);
  }

  public DecisionProof getDecisionProof(InstanceID instanceID, HashMap<Long, DecisionProof> decisionMap){
    return new ListDecisionProof(instanceID, decisionMap, params);
  }
  

}
