package code.simulator.agreement.unit;

import java.util.Collection;
import java.util.LinkedList;

import code.simulator.Hash;
import code.simulator.IrisNode;
import code.simulator.agreement.AgreementInstance;
import code.simulator.agreement.AgreementParams;
import code.simulator.agreement.DecisionProof;
import code.simulator.agreement.InstanceID;
import code.simulator.agreement.ListAgreementInstance;
import code.simulator.agreement.ListDecisionProof;
import code.simulator.agreement.ValueDecisionProof;
import code.simulator.agreement.Vote;
import code.simulator.checkpoint.unit.SimulatorCheckpointUnit;
import code.simulator.unit.SimulatorUnit;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ListAgreementInstanceUnit extends TestCase{
  public static final String TEST_ALL_TEST_TYPE = "UNIT";

  Hash [] hashes = new Hash[20];
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public ListAgreementInstanceUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    SimulatorCheckpointUnit.makePractiConfig(0, 100);
    for(int i = 0; i < 20; i++){
      byte first = (byte)(i/10);
      byte second = (byte)(i%10);
      byte[]h = new byte[20];
      for(int j = 0; j < 20; j++){
        if(j%2 ==0){
          h[j] = first;
        }else{
          h[j] = second;
        }
      }
      Hash hash = new Hash(h, false);
      hashes[i] = hash;
    }
  }

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(ListAgreementInstanceUnit.class);
    return suite;
  }

  LinkedList<TestCommunicationChannel> createCommunicationChanels(int num){
    LinkedList<TestCommunicationChannel> list = new LinkedList<TestCommunicationChannel>();
    LinkedList<Long> allNodes = new LinkedList<Long>();
    for(int i = 0; i < num; i++){
      allNodes.add(i, (long)i);
    }
    long timeout = 5*1000; // 5 sec
    for(int i = 0; i < num; i++){
      AgreementParams params = new AgreementParams(num, (num-1)/5, i, allNodes);
      TestCommunicationChannel tcc = new TestCommunicationChannel(i, 0, params, timeout, InstanceID.OmitVVAgreement);
      list.add(tcc);
      tcc.addInstance(new ListAgreementInstance(tcc.getInstanceID(), tcc));
    }

    return list;
  }

  /**
   * node receives n bottom votes
   */
  public void dotestBenignFaults(){
    for(int j = 0; j <= 6; j++){
      System.out.println("running with j  " + j);
      LinkedList<TestCommunicationChannel> nodes = this.createCommunicationChanels(6);

      for(int i = 0; i < nodes.size(); i++ ){
        if(i >= j){
          nodes.get(i).vote(hashes[i], nodes.get(i).getMyID());
        }else if(i < nodes.getFirst().getParams().strongQuorum()){
          nodes.get(i).vote(null, nodes.get(i).getMyID());
        }
        // now control message flow
        syncAll(nodes.get(i), nodes);
      }

      if(j > 0){
        try{
          Thread.sleep(10000);
        }catch(InterruptedException e){
          // TODO Auto-generated catch block
          e.printStackTrace();
        }
        for(TestCommunicationChannel tc: nodes){
          assert tc.instance.isTimedOut(): tc;
        }
      }

      // now everyone has the voted
      for(TestCommunicationChannel tc: nodes){
        syncAll(tc, nodes);
      }

      for(TestCommunicationChannel tc: nodes){
        assert tc.getDecisionProof() != null: tc.getMyID() + "\n tc" + tc.messages + " \n" + tc.messages.size() + " \n " + tc.getDecisionProof() + "\n" + tc.instance;
        assert (tc.getDecisionProof() instanceof ListDecisionProof): tc.getDecisionProof();
        ListDecisionProof ldp = (ListDecisionProof)tc.getDecisionProof();
        Collection<DecisionProof> dps = ldp.getProofs();
        for(DecisionProof dp:dps){
          assert dp instanceof ValueDecisionProof;
          ValueDecisionProof vdp = (ValueDecisionProof)dp;
          Vote decidedVal = vdp.getDecidedValue();
          int index = (int)decidedVal.getInstanceID().getNodeId();
          if(index >= j){
            assert decidedVal.getData().equals(hashes[index]): "\n" + decidedVal + "\n" + index + "\n" + hashes[index];
          }else{
            assert decidedVal.isBottom():decidedVal;
          }
        }
      }

    }

  }

  /**
   * node receives n bottom votes
   */
  public void testOmissionFaults(){
    LinkedList<TestCommunicationChannel> nodes = this.createCommunicationChanels(6);

    for(int i = 0; i < nodes.size(); i++ ){
      if(i != 0){
        nodes.get(i).vote(hashes[i], nodes.get(i).getMyID());
        // now control message flow
        syncAll(nodes.get(i), nodes);
      }

    }
    
    try{
      Thread.sleep(10000);
    }catch(InterruptedException e){
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
    for(TestCommunicationChannel tc: nodes){
      assert tc.instance.isTimedOut(): tc;
    }

    // now everyone has the voted
    for(TestCommunicationChannel tc: nodes){
      if(tc.getMyID()!=0){
        syncAll(tc, nodes);
      }
    }
    

    for(TestCommunicationChannel tc: nodes){
      assert tc.getDecisionProof() != null: tc.getMyID() + "\n tc" + tc.messages + " \n" + tc.messages.size() + " \n " + tc.getDecisionProof() + "\n" + tc.instance;
      assert (tc.getDecisionProof() instanceof ListDecisionProof): tc.getDecisionProof();
      ListDecisionProof ldp = (ListDecisionProof)tc.getDecisionProof();
      Collection<DecisionProof> dps = ldp.getProofs();
      for(DecisionProof dp:dps){
        assert dp instanceof ValueDecisionProof;
        ValueDecisionProof vdp = (ValueDecisionProof)dp;
        Vote decidedVal = vdp.getDecidedValue();
        int index = (int)decidedVal.getInstanceID().getNodeId();
        if(index >= 1){
          assert decidedVal.getData().equals(hashes[index]): "\n" + decidedVal + "\n" + index + "\n" + hashes[index];
        }else{
          assert decidedVal.isBottom():decidedVal;
        }
      }
    }


  }

  public void dotestNoFailure(){
    // run the expt twice, first with quick responses from everyone..second time with slow response
    for(int j = 0; j <= 6; j++){
      System.out.println("running with j  " + j);
      LinkedList<TestCommunicationChannel> nodes = this.createCommunicationChanels(6);

      for(int i = 0; i < nodes.size(); i++ ){
        if(i >= j){
          nodes.get(i).vote(hashes[i], nodes.get(i).getMyID());
        }else{
          nodes.get(i).vote(null, nodes.get(i).getMyID());
        }
        // now control message flow
        syncAll(nodes.get(i), nodes);
      }

      if(j > 0){
        try{
          Thread.sleep(10000);
        }catch(InterruptedException e){
          // TODO Auto-generated catch block
          e.printStackTrace();
        }
        for(TestCommunicationChannel tc: nodes){
          assert tc.instance.isTimedOut(): tc;
        }
      }

      // now everyone has the voted
      for(TestCommunicationChannel tc: nodes){
        syncAll(tc, nodes);
      }

      for(TestCommunicationChannel tc: nodes){
        assert tc.getDecisionProof() != null: tc.getMyID() + "\n tc" + tc.messages + " \n" + tc.messages.size() + " \n " + tc.getDecisionProof() + "\n" + tc.instance;
        assert (tc.getDecisionProof() instanceof ListDecisionProof): tc.getDecisionProof();
        ListDecisionProof ldp = (ListDecisionProof)tc.getDecisionProof();
        Collection<DecisionProof> dps = ldp.getProofs();
        for(DecisionProof dp:dps){
          assert dp instanceof ValueDecisionProof;
          ValueDecisionProof vdp = (ValueDecisionProof)dp;
          Vote decidedVal = vdp.getDecidedValue();
          int index = (int)decidedVal.getInstanceID().getNodeId();
          if(index >= j){
            assert decidedVal.getData().equals(hashes[index]): "\n" + decidedVal + "\n" + index + "\n" + hashes[index];
          }else{
            assert decidedVal.isBottom():decidedVal;
          }
        }
      }

    }

  }

  private void syncAll(TestCommunicationChannel src, Collection<TestCommunicationChannel> channels){
    for(TestCommunicationChannel tc: channels){
      tc.sync(src);
    }
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "TestListAgreementInstanceUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}
