package code.simulator.agreement.unit;

import java.util.Collection;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.TreeSet;

import code.AcceptStamp;
import code.NodeId;
import code.ObjId;
import code.SubscriptionSet;
import code.serialization.SerializationHelper;
import code.simulator.Hash;
import code.simulator.HashedVV;
import code.simulator.IrisDataObject;
import code.simulator.IrisObject;
import code.simulator.NamespaceWatch;
import code.simulator.agreement.AgreementInstance;
import code.simulator.agreement.AgreementInterface;
import code.simulator.agreement.AgreementMonitor;
import code.simulator.agreement.AgreementParams;
import code.simulator.agreement.CommunicationChannel;
import code.simulator.agreement.DecisionProof;
import code.simulator.agreement.InstanceID;
import code.simulator.agreement.Vote;
import code.simulator.agreement.VoteFactory;
import code.simulator.protocolFilters.AgreementGCProtocol;
import code.simulator.store.StoreEntry;

public class TestCommunicationChannel implements CommunicationChannel, AgreementMonitor{

  LinkedList<NamespaceWatch> watches;
  final long myID;
  int epoch;
  AgreementInterface instance;
  final InstanceID instanceID;
  final VoteFactory vf;
  final AgreementParams params;
  final long timeout;
  DecisionProof dp;
  int count;
  TreeSet<StoreEntry> messages;
  int msgCount;
  
  public TestCommunicationChannel(long id, int epoch, AgreementParams params, long timeout, byte phase){
    this.myID = id;
    this.epoch = epoch;
    instanceID = new InstanceID(epoch, phase, InstanceID.NullNode);
    this.params = params;
    vf = new VoteFactory(params);
    this.timeout = timeout;
    watches = new LinkedList<NamespaceWatch>();
    msgCount = 0;
    dp = null;
    count = 0;
    messages = new TreeSet<StoreEntry>();
    TimerTask task = new TimerTask(){
      public void run(){
        handleTimeout();
      }
    };
    AgreementInstance.timer.scheduleAtFixedRate(task, this.getTimeOut(), this.getTimeOut());
  }
  
  synchronized private void handleTimeout(){
    if(this.instance != null){
      instance.notifyTimeout();
    }
  }
  
  public void addInstance(AgreementInterface ai){
    this.instance = ai;
    addNamespaceWatch(new TestGCWatch(instance, this), SubscriptionSet.makeSubscriptionSet(AgreementGCProtocol.gcProposalDir + "/*"));
  }
  
  private ObjId getObjId(){
    return new ObjId(AgreementGCProtocol.gcProposalDir+"/"+params.getMyID()+"/"+epoch+"/"+(msgCount++));
  }
  
  public void addNamespaceWatch(NamespaceWatch mr, SubscriptionSet ss){
    watches.add(mr);
  }

  public void broadcast(Object o){
    assert watches.size() != 0;
    StoreEntry se = new StoreEntry(new IrisDataObject(o), new AcceptStamp(count++, new NodeId(this.myID)), Hash.NullHash, false);
    this.receive(params.getMyID(), se);
  }
  
  public void sync(TestCommunicationChannel tcc){
    assert watches.size() != 0;
    for(StoreEntry se: tcc.messages){
      if(!messages.contains(se)){
        receive(se.getAcceptStamp().getNodeId().getIDint(), se);
      }
    }
  }

  public void receive(Long sender, StoreEntry se){
    assert watches.size() != 0;
    this.messages.add(se);
    for(NamespaceWatch nw: watches){
      nw.notifyWrite(epoch, new ObjId(""), se);
    }
  }

  public long getMyID(){
    return myID;
  }

  public CommunicationChannel getChannel(){
    // TODO Auto-generated method stub
    return this;
  }

  public AgreementParams getParams(){
    // TODO Auto-generated method stub
    return params;
  }

  public long getTimeOut(){
    // TODO Auto-generated method stub
    return timeout;
  }

  public VoteFactory getVoteFactory(){
    // TODO Auto-generated method stub
    return vf;
  }
  
  public DecisionProof getDecisionProof(){
    return dp;
  }

  public void notifyDecision(InstanceID instanceID, DecisionProof dp){
    // TODO Auto-generated method stub
    this.dp = dp;
  }

  public InstanceID getInstanceID(){
    return instanceID;
  }

  public void vote(Hash hash, long nid){
    InstanceID iid = new InstanceID(this.getInstanceID().getEpoch(), this.getInstanceID().getPhase(), nid);
    Vote<Hash> vote = new Vote<Hash>(iid, 0, hash);
    this.broadcast(vote);
  }
  
  public void vote(Hash hash){
   vote(hash, InstanceID.NullNode);
  }

  @Override
  public String toString(){
    return "TestCommunicationChannel [myID=" + myID + "]";
  }

  public int getEpoch(){
    // TODO Auto-generated method stub
    return epoch;
  }

  public void voteLocal(Hash hash){
    this.vote(hash, this.params.getMyID());
  }

}
