package code.simulator.agreement.unit;

import code.ObjId;
import code.serialization.SerializationHelper;
import code.simulator.IrisDataObject;
import code.simulator.IrisObject;
import code.simulator.NamespaceWatch;
import code.simulator.agreement.AgreementInstance;
import code.simulator.agreement.AgreementInterface;
import code.simulator.agreement.AgreementMonitor;
import code.simulator.agreement.DecisionProof;
import code.simulator.agreement.InstanceID;
import code.simulator.agreement.ListDecisionProof;
import code.simulator.agreement.Vote;
import code.simulator.store.StoreEntry;

public class TestGCWatch implements NamespaceWatch{
  
  final AgreementInterface ai;
  final AgreementMonitor tai;
  public TestGCWatch(AgreementInterface ai, AgreementMonitor tai){
    this.ai = ai;
    this.tai = tai;
  }

  public void notifyCheckpoint(int epoch){
    assert false;
  }

  public void notifyWrite(int epoch, ObjId o, StoreEntry se){
    DecisionProof dp = null;
    Vote v = null;
    InstanceID instanceID = null;
    IrisObject irisObj = se.getData();
    assert irisObj instanceof IrisDataObject;
    Object obj = ((IrisDataObject)irisObj).getObject();
    if(obj instanceof DecisionProof){
      dp = (DecisionProof)obj;
      instanceID = dp.getInstanceID();
      ai.receiveDecisionProof(dp);
      if(ai instanceof AgreementInstance){
        tai.notifyDecision(ai.getInstanceID(), dp);
      }else if(dp instanceof ListDecisionProof){
        tai.notifyDecision(dp.getInstanceID(), dp);
      }
    }else if(obj instanceof Vote){
      v = (Vote)obj;
      instanceID = v.getInstanceID();
      ai.receiveVote(se.getAcceptStamp().getNodeId().getIDint(), v);
    }else{
      assert false;
    } 
  }

}
