package code.simulator.branchManager;

import code.branchDetecting.*;
public class LogBranchSegment{

  BranchID branchID;
  long startTS;
  long endTS;
  
  public LogBranchSegment(BranchID branchID, long startTS, long endTS){
    this.branchID = branchID;
    this.startTS = startTS;
    this.endTS = endTS;
  }
  
  public LogBranchSegment(BranchID branchID, long startTS){
    this(branchID, startTS, Long.MAX_VALUE);
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + ((branchID == null) ? 0 : branchID.hashCode());
    result = prime * result + (int) (endTS ^ (endTS >>> 32));
    result = prime * result + (int) (startTS ^ (startTS >>> 32));
    return result;
  }
  
  @Override
  public boolean equals(Object obj){
    if(this == obj)
      return true;
    if(obj == null)
      return false;
    if(getClass() != obj.getClass())
      return false;
    final LogBranchSegment other = (LogBranchSegment) obj;
    if(branchID == null){
      if(other.branchID != null)
        return false;
    }else if(!branchID.equals(other.branchID))
      return false;
    if(endTS != other.endTS)
      return false;
    if(startTS != other.startTS)
      return false;
    return true;
  }
  
  
}
