package code.simulator.branchManager;

import java.util.*;
public class SimpleTreeNode<E>{

  private final LinkedList<SimpleTreeNode<E>> children;
  final E element;
  private SimpleTreeNode<E> parent;
  private boolean leaf;
  
  public SimpleTreeNode(E e){
    this.element = e;
    this.children = new LinkedList<SimpleTreeNode<E>>();
    parent = null;
    leaf = true;
  }
  
  public SimpleTreeNode(E e, Collection<SimpleTreeNode<E>> children){
    this.element = e;
    this.children = new LinkedList<SimpleTreeNode<E>>(children);
    parent = null;
    leaf = true;
  }

  synchronized public LinkedList<SimpleTreeNode<E>> getChildren(){
    return children;
  }
  
  synchronized public Collection<SimpleTreeNode<E>> getAllSubtreeNodes(){
    LinkedList<SimpleTreeNode<E>> childrens = new LinkedList<SimpleTreeNode<E>>();
    childrens.add(this);
    for(SimpleTreeNode<E> stn: children){
      childrens.addAll(stn.getAllSubtreeNodes());
    }
    return childrens;
  }

  synchronized public boolean equals(Object o){
    if(!(o instanceof SimpleTreeNode)){
      return false;
    }else{
      SimpleTreeNode t = (SimpleTreeNode)o;
      return (o != null) && element.equals(t.element) && leaf == t.leaf && children.equals(t.children);// && (parent != null?parent.equals(t.parent):t.parent==null);
    }
  }
  
  synchronized public int hashCode(){
    return "TreeNode".hashCode() + element.hashCode()  + new Boolean(leaf).hashCode() + children.hashCode(); //+ (parent!= null?parent.hashCode():0);
  }
  
  synchronized public SimpleTreeNode<E> getParent(){
    return parent;
  }

  synchronized public void setParent(SimpleTreeNode<E> parent){
    this.parent = parent;
  }
  
  synchronized public SimpleTreeNode<E> findMatchingTreeNodes(E e) throws Exception{
    SimpleTreeNode<E> match = null;
    for(SimpleTreeNode<E> stn: children){
      SimpleTreeNode<E> localMatch = stn.findMatchingTreeNodes(e);
      if(localMatch != null && match == null){
        match = localMatch;
      }else if(match != null && localMatch != null){
        throw new Exception("Multiple matches for " + e);
      }
    }
    if(e.equals(element)){
      if(match == null){
        return this;
      }else{
        throw new Exception("Multiple matches for " + e);
      }
    }
    else{
      return match;
    }
  }

  synchronized public boolean isLeaf(){
    return leaf;
  }

  synchronized public void setLeaf(boolean leaf){
    this.leaf = leaf;
  }
  
  synchronized SimpleTreeNode<E> deepClone(){
    SimpleTreeNode<E> newTreeNode = new SimpleTreeNode<E>(this.element);
    newTreeNode.leaf = this.leaf;
    for(SimpleTreeNode<E> stnC:this.children){
      SimpleTreeNode<E> stnCClone = stnC.deepClone();
      stnCClone.setParent(newTreeNode);
      newTreeNode.children.add(stnCClone);
    }
    return newTreeNode;
  }
  
  @Override
  synchronized public String toString(){
    String str = "";
    str += this.element+ (leaf?" Leaf ":" Non-leaf ") + " children: " + (children.size()!=0?"{" + this.children + "}":"NULL");
    return str;
  }

  public TreeSet<SimpleTreeNode<E>> getAllLeafNodes(){
    TreeSet<SimpleTreeNode<E>> ret = new TreeSet<SimpleTreeNode<E>>();
    if(leaf){
      assert children.size() == 0;
      ret.add(this.deepClone());      
    }else{
      for(SimpleTreeNode<E> stn: this.children){
        ret.addAll(stn.getAllLeafNodes());
      }
    }
    return ret;
  }

}
