package code.simulator.branchManager;

public class TreeNode<E>{

  final TreeNode<E> parent;
  final E element;
  
  public TreeNode(E e){
    this.element = e;
    this.parent = null;
  }
  
  public TreeNode(E e, TreeNode<E> parent){
    this.parent = parent;
    this.element = e;
  }

  public TreeNode<E> getParent(){
    return parent;
  }

  public boolean equals(Object o){
    if(!(o instanceof TreeNode)){
      return false;
    }else{
      TreeNode t = (TreeNode)o;
      return (o != null) && element.equals(t.element) && (parent != null?parent.equals(t.parent):t.parent==null);
    }
  }
  
  public int hashCode(){
    return "TreeNode".hashCode() + element.hashCode() + (parent!= null?parent.hashCode():0);
  }
  
  public String toString(){
    return "TreeNode: " + element + " hashCode: " + hashCode(); 
  }
  
}
