package code.simulator.branchManager.unit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import code.simulator.branchManager.*;
import java.util.*;

public class SimpleTreeUnit extends TestCase{

public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public SimpleTreeUnit (final String s) {
    super (s);
  }

  public void testSimpleTree(){
    try{
      // first populate the tree
      // 1
      // 2      3
      // 4   5  6 7
      // 8 9    A 

      SimpleTree<Integer> t = new SimpleTree<Integer>();
      t.addVal(null, 1);
      t.markNonLeaf(1);
      t.addVal(1, 2);
      t.markNonLeaf(2);
      t.addVal(2, 4);
      t.markNonLeaf(4);
      t.addVal(4, 8);
      t.addVal(4, 9);
      t.addVal(2, 5);
      t.addVal(1, 3);
      t.markNonLeaf(3);
      t.addVal(3, 6);
      t.addVal(3, 7);
      t.markNonLeaf(6);
      t.addVal(6, 10);
      
      // now test find
      ArrayList<Integer> valList = new ArrayList<Integer>();
      valList.add(1);
      valList.add(2);
      valList.add(3);
      valList.add(4);
      valList.add(5);
      valList.add(6);
      valList.add(7);
      valList.add(8);
      valList.add(9);
      valList.add(10);
      
      // now test isLeaf
      LinkedList<Integer> leaves = new LinkedList<Integer>();
      leaves.add(10);
      leaves.add(7);
      leaves.add(9);
      leaves.add(8);
      leaves.add(5);
      
      for(int i = 0; i < valList.size(); i++){
        assert !(leaves.contains(valList.get(i)) ^ t.isLeaf(valList.get(i)));
      }
      
      // now test getChildren
      assert t.getChildren(10).isEmpty();
      assert t.getChildren(1).contains(2);
      
      // test getConcurrentNodes
      assert t.getConcurrentNodes(1).isEmpty();
      assert t.getConcurrentNodes(2).contains(3);
      assert !t.getConcurrentNodes(2).contains(1);
      assert !t.getConcurrentNodes(2).contains(4);
      
      // test pushIntermediateNode
      t.pushNewIntermediateChild(3, 0);
      assert !t.getChildren(3).contains(6);
      assert t.getChildren(3).contains(0);
      assert t.getConcurrentNodes(0).contains(2);
      assert t.getConcurrentNodes(0).contains(4);
      assert t.getConcurrentNodes(0).contains(5);
      assert t.getConcurrentNodes(0).contains(8);
      assert t.getConcurrentNodes(0).contains(9);
      assert !t.getConcurrentNodes(0).contains(6);
      assert !t.getConcurrentNodes(0).contains(7);
      assert !t.getConcurrentNodes(0).contains(0);
      assert !t.getConcurrentNodes(0).contains(3);
      assert !t.getConcurrentNodes(0).contains(1);
      
      // test popIntermediateNode
      t.popIntermediateNode(0);
      assert t.getChildren(3).contains(6);
      assert t.getChildren(3).contains(7);
      assert !t.getChildren(3).contains(0);
      
      //test getBranchMap
      TreeSet<Integer> branches = new TreeSet<Integer>();
      branches.add(8);
      branches.add(9);
      branches.add(10);
      HashMap<Integer, Integer> branchMap = t.getBranchMap(branches);
      assert branchMap.get(10) == 3:branchMap;
      assert branchMap.get(6) == 3:branchMap;
      branchMap.remove(10);
      branchMap.remove(6);
      assert branchMap.isEmpty();
      
      branches.remove(8);
      branchMap = t.getBranchMap(branches);
      assert branchMap.get(10) == 3:branchMap;
      branchMap.remove(10);
      assert branchMap.get(9) == 2:branchMap.get(9) + "  " + branchMap;
      branchMap.remove(9);
      assert branchMap.get(4) == 2:branchMap.get(9) + "  " + branchMap;
      branchMap.remove(4);
      assert branchMap.get(6) == 3:branchMap.get(9) + "  " + branchMap;
      branchMap.remove(6);
      assert branchMap.isEmpty():branchMap;
      
      //test areBranchesConcurrent?
      branches.clear();
      branches.add(1);
      branches.add(9);
      assert !t.areBranchesConcurrent(branches);
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    
  }
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
 
  }


  

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(SimpleTreeUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "SimpleTreeUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}
