package code.simulator.branchManager.unit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import code.simulator.branchManager.*;
import java.util.*;

public class TreeUnit extends TestCase{

public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public TreeUnit (final String s) {
    super (s);
  }

  public void testTree(){
    try{
      // first populate the tree
      // 1
      // 2      3
      // 4   5  6 7
      // 8 9    A 

      Tree<Integer> t = new Tree<Integer>();
      TreeNode<Integer> tn1 = t.addVal(null, 1);
      TreeNode<Integer> tn12 = t.addVal(tn1, 2);
      TreeNode<Integer> tn124 = t.addVal(tn12, 4);
      TreeNode<Integer> tn1248 = t.addVal(tn124, 8);
      TreeNode<Integer> tn1249 = t.addVal(tn124, 9);
      TreeNode<Integer> tn125 = t.addVal(tn12, 5);
      TreeNode<Integer> tn13 = t.addVal(tn1, 3);
      TreeNode<Integer> tn136 = t.addVal(tn13, 6);
      TreeNode<Integer> tn137 = t.addVal(tn13, 7);
      TreeNode<Integer> tn136A = t.addVal(tn136, 10);
      
      // now test find
      ArrayList<TreeNode<Integer>> valList = new ArrayList<TreeNode<Integer>>();
      valList.add(tn1);
      valList.add(tn12);
      valList.add(tn13);
      valList.add(tn124);
      valList.add(tn125);
      valList.add(tn136);
      valList.add(tn137);
      valList.add(tn1248);
      valList.add(tn1249);
      valList.add(tn136A);
      
      for(int i = 0; i < valList.size(); i++){
        LinkedList<TreeNode<Integer>> list = t.findMatchingTreeNodes(i+1);
        assert list.size() == 1;
        assert list.getFirst().equals(valList.get(i));
      }
      
      
      // now test isLeaf
      LinkedList<TreeNode<Integer>> leaves = new LinkedList<TreeNode<Integer>>();
      leaves.add(tn136A);
      leaves.add(tn137);
      leaves.add(tn1249);
      leaves.add(tn1248);
      leaves.add(tn125);
      
      for(int i = 0; i < valList.size(); i++){
        assert !(leaves.contains(valList.get(i)) ^ t.isLeaf(valList.get(i)));
      }
      
      // now test getChildren
      assert t.getChildren(tn136A).isEmpty();
      assert t.getChildren(tn1).contains(tn12);
      
      // test getConcurrentNodes
      assert t.getConcurrentNodes(tn1).isEmpty();
      assert t.getConcurrentNodes(tn12).contains(tn13);
      assert !t.getConcurrentNodes(tn12).contains(tn1);
      assert !t.getConcurrentNodes(tn12).contains(tn124);
      
      // test pushIntermediateNode
      TreeNode<Integer> tn10 = t.pushNewIntermediateNode(tn13, 0);
      assert tn10.getParent().equals(tn1);
      assert !t.getChildren(tn10).contains(tn13);
      tn13 = t.findMatchingTreeNodes(3).getFirst();
      assert t.getChildren(tn10).contains(tn13);
      assert t.getConcurrentNodes(tn10).contains(tn12);
     
      
      // test popIntermediateNode
      t.popIntermediateNode(tn10);
      tn13 = t.findMatchingTreeNodes(3).getFirst();
      assert t.getChildren(tn1).contains(tn13);
      assert tn13.getParent().equals(tn1);
      assert t.getChildren(tn1).contains(tn13);
      assert !t.getChildren(tn1).contains(tn10);
    }catch(Exception e){
      // TODO Auto-generated catch block
      e.printStackTrace();
      assert false;
    }
    
  }
  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
 
  }


  

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(TreeUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "TreeUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}
