package code.simulator.distributionsimulation;

import java.util.*;

public class Configuration extends HashMap<Integer, Integer>{
  private int largestPathLength = 0;
  private int uninfectedNodes = Distribution.Nodes;
  
  public Configuration(){
    largestPathLength = 0;
    uninfectedNodes = Distribution.Nodes;
  }
  
  public static Configuration getBaseConfiguration(){
    Configuration c = new Configuration();
    c.put(0, 1);
    return c;
  }
  
  @Override
  public Integer put(Integer key, Integer value){
    // TODO Auto-generated method stub
    if(this.containsKey(key)){
      uninfectedNodes += this.get(key);
    }
    if(key > this.largestPathLength){
      largestPathLength = key;
    }
    uninfectedNodes -= value;

    return super.put(key, value);
  }


  @Override
  public void putAll(Map<? extends Integer, ? extends Integer> m){
    // TODO Auto-generated method stub
    for(Integer i: m.keySet()){
      if(this.containsKey(i)){
        uninfectedNodes += this.get(i);
      }
      if(i > this.largestPathLength){
        largestPathLength = i;
      }
      uninfectedNodes -= m.get(i);
    }
    super.putAll(m);
  }


  @Override
  public Integer remove(Object key){
    // TODO Auto-generated method stub
    uninfectedNodes += this.get(key);
    Integer i = super.remove(key);

    int ki = (Integer)key;
    if(ki == this.largestPathLength){
      this.largestPathLength = -1;
      for(Integer ii: this.keySet()){
        if(ii > this.largestPathLength){
          this.largestPathLength = ii;
        }
      }
    }
    
    return i;
  }


  public HashMap<Configuration, Float> getAllFeasibleLastSteps(){
    HashMap<Configuration, Float> allC = new HashMap<Configuration, Float>();
    
    for(Integer i:this.keySet()){
      assert this.get(i) > 0;
      if(i > 0 && 
         ( (i!=this.largestPathLength && this.get(i) > 1 ) ||
            i == this.largestPathLength)){
        
        Configuration newC = (Configuration)this.clone();
        if(this.get(i) > 1){
          newC.put(i, this.get(i)-1);
        }else{
          newC.remove(i);
        }
        double numEmpty = newC.uninfectedNodes;
        double numUsefulInfected = this.get(i-1);
        double n = Distribution.Nodes;
        float probS = (float)((numEmpty*numUsefulInfected)/(n*(n-1)));
        float probNothingChanges = (float)(1-(numEmpty*(n-numEmpty))/(n*(n-1)));
        float prob = probS*(1/(1-probNothingChanges));
        //assert prob <= 1: "numEmpty" + newC + " probS " + probS + " probNothingChanges " + probNothingChanges + " prob "  + prob;
        if(allC.containsKey(newC)){
          allC.put(newC, allC.get(newC)+prob);
        }else{
          allC.put(newC, prob);
        }
      }
    }
    
    return allC;
  }


  @Override
  public Object clone(){
    // TODO Auto-generated method stub
    Configuration c = new Configuration();
    c.putAll(this);
    c.largestPathLength = this.largestPathLength;
    c.uninfectedNodes = this.uninfectedNodes;
    return c;
  }

  public int getLargestPathLength(){
    return largestPathLength;
  }

  public int getUninfectedNodes(){
    return uninfectedNodes;
  }
  
  public String toString(){
    return super.toString() + "Uninfected nodes: " + this.uninfectedNodes + " largestPath: " + this.largestPathLength;
  }
}
