package code.simulator.distributionsimulation;

import java.util.*;
import java.lang.*;

public class Distribution{

  public static int Nodes = 20;
  public static int NumFailures = 1;
  public static int log = 0;
  public static final boolean optimize = true;
  public static final boolean useStaticPathDist = false;

  HashMap<Configuration, Float> probabilityDistribution;
  double[] pathProb;
  
  HashSet<Configuration> configMap;
  
  public Distribution(){
    log = Nodes;
    System.out.println("log" + log);
    probabilityDistribution = new HashMap<Configuration, Float>();
    this.probabilityDistribution.put(Configuration.getBaseConfiguration(), (float)1);
    configMap = new HashSet<Configuration>();
  }
  
  private float getProb(Configuration c){
    if(this.probabilityDistribution.containsKey(c)){
      return this.probabilityDistribution.get(c);
    }else{
      return 0;
    }
  }
  public void computeDistribution(Configuration c){
    if(this.probabilityDistribution.containsKey(c)){
      return;
    }else{
      if(optimize){
        if(c.getLargestPathLength() >= log){
          //this.probabilityDistribution.put(c, (float)0);
          return;
        }
      }
      HashMap<Configuration, Float> lastSteps = c.getAllFeasibleLastSteps();
      float prob = 0;
      for(Configuration lc: lastSteps.keySet()){
        if(!this.probabilityDistribution.containsKey(lc)){
          this.computeDistribution(lc);
        }
        prob += this.getProb(lc)*lastSteps.get(lc);
      }
//      float N = this.Nodes;
//      float u = c.getUninfectedNodes();
//      if(c.getUninfectedNodes() > 0){
//        prob *= (N*(N-1)/(u*(N-u)));
//      }
      this.probabilityDistribution.put(c, prob);
    }
  }
  
  
  
  HashSet<Configuration> getAllConfigurations(Configuration baseC){
    HashSet<Configuration> allC = new HashSet<Configuration>();
    if(optimize){
      if(baseC.getLargestPathLength() >= log){
        return allC;
      }
    }
    if(this.configMap.contains(baseC)){
      return allC;
    }else{
      configMap.add(baseC);
    }
    if(baseC.getUninfectedNodes() == 0){
      allC.add(baseC);
      configMap.add(baseC);
      return allC;
    }
    for(Integer k: baseC.keySet()){
      if(k != 0){
        Configuration newC = (Configuration)baseC.clone();
        newC.put(k, baseC.get(k)+1);
        allC.addAll(this.getAllConfigurations(newC));
      }
    }
    Configuration newC = (Configuration)baseC.clone();
    newC.put(baseC.getLargestPathLength()+1, 1);
    allC.addAll(this.getAllConfigurations(newC));
    configMap.add(baseC);
    return allC;
  }
  
  /**
   * probability that an i hop path is fault free
   * @return
   */
  public double prob(int i){
    return comb(Distribution.Nodes-Distribution.NumFailures, i)/comb(Distribution.Nodes, i);
  }
  
  public double comb(int n, int i){
    if(n < i){
      return 0;
    }
    return fact(n)/(fact(n-i)*fact(i));
  }
  
  public double fact(int n){
    double res = 1;
    for(int j = n; j > 0; j--){
      res *= j;
    }
    return res;
  }
  
  void getPathProb(HashSet<Configuration> configs){
    pathProb = new double[this.Nodes];
    for(int i = 0; i  < this.Nodes; i++){
      pathProb[i] =(double)0;
    }
    for(Configuration c: configs){
      float prob = this.probabilityDistribution.get(c);
      for(Integer pathLength:c.keySet()){
        pathProb[pathLength] += prob*c.get(pathLength);
      }
    }
    for(int i = 0; i  < this.Nodes; i++){
      pathProb[i] /= this.Nodes;
    }
  }
  public void printPathProbDistribution(){
    
    for(int i = 0; i  < this.Nodes; i++){
      System.out.println("Pathlength " + i + " : " + (pathProb[i]));
    }
    
    float N = (float)this.Nodes;
    float fail = (float)this.NumFailures;
    float msgLossProb = 0;//fail*(N-fail)/(N*(N-1));//prob that message originates at the faulty node and is intended for other correct nodes
    float correctNodeProb = (1-fail/N);
    for(int i = 1; i  < this.Nodes; i++){
      double msgLossProb1 = (1-prob(i+1))*pathProb[i]; //(float)(1-Math.pow(correctNodeProb, i-1))*pathProb[i]/N;
      System.out.println("Pathlength " + i + " : " + (pathProb[i]) + " prob of failure: " + (1-prob(i+1)) + " msgLossProb due to path " + i + " " + msgLossProb1);
      msgLossProb += msgLossProb1;
    }

    System.out.println("Message loss probability: " + msgLossProb );//+ " inconsistency obs at oracle " + (msgLossProb*(this.Nodes)-this.NumFailures)/(this.Nodes-this.NumFailures));
    
    
  }
  
  public static void main(String[] args){
  //find all possible final distributions and calculate their probability
    //System.out.println("All configurations" + d.getAllConfigurations(Configuration.getBaseConfiguration()));
    if(args.length > 0){
      System.out.println(args);
      Distribution.Nodes = Integer.parseInt(args[0]);
    }
    if(args.length > 1){
      Distribution.NumFailures = Integer.parseInt(args[1]);
    }
    Distribution d = new Distribution();
    
    long stime = System.currentTimeMillis();
    if(!Distribution.useStaticPathDist){

    HashSet<Configuration> configs = d.getAllConfigurations(Configuration.getBaseConfiguration());
//    System.out.println(configs);
    long etime = System.currentTimeMillis();
    System.out.println("Computed all configurations.. took" + (etime-stime)/1000 + "s");
    d.configMap.clear();
    for(Configuration c: configs){
      if(!d.probabilityDistribution.containsKey(c)){
        d.computeDistribution(c);        
      }
//      System.out.println(c + " prob " + d.probabilityDistribution.get(c));
    }
    
   
    d.getPathProb(configs);
    }else{
      d.pathProb = new double[]{
          0.05
          ,0.1807
          ,0.288825
          ,0.252675
          ,0.1461
          ,0.060975
          ,0.018525
          ,0.0022
          ,0
          ,0
          ,0
          ,0
          ,0
          ,0
          ,0
          ,0
          ,0
          ,0
          ,0
          ,0
          ,0
      };
    }
    d.printPathProbDistribution();
    System.out.println("finished... took" + (System.currentTimeMillis()-stime)/1000 + "s");

  }
}
