package code.simulator.distributionsimulation;

public class Test{

  double perm[][];
  double prob[][];

  int N;
  
  public Test(int N){
    this.N = N;
    perm = new double[N+1][];
    prob = new double[N+1][];
    for(int i = 0; i <= N; i++){
      perm[i] = new double[N+1];
      prob[i] = new double[N+1];
      for(int j = 0; j <= N; j++){
        perm[i][j] = -1;
        prob[i][j] = -1;
        if(i ==j){
          perm[i][j]=1;
        }
      }
    }
    prob[0][0] = 1;
    perm[1][0] = 1;
    
  }
  
  public double f(int n, int w){
    if(perm[n][w] != -1){
      return perm[n][w];
    }else{
      double res = ((n>0 && w>0)?f(n-1,w-1):0) + ((n>=(2*w+1))?f(n-1,w):0);
      perm[n][w] = res;
      return res;
    }
  }
  
  /**
   * Probability that w wins and (n-w) losses occur such that at all times (for all prefixes), number of losses >= number of wins 
   * @param n
   * @param w
   * @return
   */
  public double prob(int n, int w){
    if(prob[n][w] != -1){
      return prob[n][w];
    }else{
      double res = 0.5*((n>0 && w>0)?prob(n-1,w-1):0) + 0.5*((n>=(2*w+1))?prob(n-1,w):0);
      prob[n][w] = res;
      return res;
    }
  }
  
  public static double product(int k){
    double K = (double)k;
    return (2*K+3)/(2*K+4);
  }
  
  
  public static void main1 (String[] args){
    int startK = 1;
    int endK = 150;
    double totalSucc = 0; 
   
    double prevBase = 0.5;
    double succInK = 0;
    double succInK1 = 0.5;
    for(int k = startK; k < endK; k++){
      prevBase = prevBase*product(k); // computing f(k) = (2k+3)/(2k+4)*f(k-1)
      succInK = succInK1 + prevBase*(1-succInK1); // computing F(k) = (1-F(k-1))*f(k)
      succInK1 = succInK; //F(k-1)
//      System.out.println(succInK);
    }
    
//    System.out.println(succInK);
    
  }
  
  public static void main2(String []args){
    int N = 5;
    Test t = new Test(N);
    double prob = 0;
    double total = 0;
//    t.f(N-1, N-1);
    for(int i = 0; i <= N; i++){
      if((i%2)!=0){
        System.out.println("i" + i + " " + t.f(i-1, (i-1)/2));
        total += t.f(i-1, (i-1)/2);
      }
    }
    
//    for(int i = 0; i < N; i++){
//      System.out.println();
//      for(int j = 0; j < N; j++){
//        System.out.print(t.perm[i][j] + "\t");
//      }
//    }
    System.out.println(total);
    
    double totalCase = 0;
    int maxLoss = (N+1)/2;
    for(int i = maxLoss; i <= N; i++){
      System.out.println("i" + i + " maxLoss" + maxLoss + " " + t.f(i-1, i-maxLoss));
      totalCase += t.f(i-1, i-maxLoss);
    }
    
    System.out.println(totalCase+total);
    System.out.println(totalCase);
    System.out.println(total/(total+totalCase));
    
  }
  
  public static void main(String []args){
    int N = 9001;
    Test t = new Test(N);
    double prob = 0;
//    t.f(N-1, N-1);
    for(int i = 0; i <= N; i++){
      if((i%2)!=0){
        System.out.println("i" + i + " " + t.prob(i-1, (i-1)/2));
        prob += 0.5*t.prob(i-1, (i-1)/2);
      }
    }
    
//    for(int i = 0; i < N; i++){
//      System.out.println();
//      for(int j = 0; j < N; j++){
//        System.out.print(t.perm[i][j] + "\t");
//      }
//    }
    System.out.println(prob);

    
  }
  
}
