package code.simulator.irisnetty;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

import code.simulator.netty.Pair;
import code.Config;
import code.NodeId;
import code.serialization.IrisOutputStream;
import code.serialization.IrisSerializable;
import code.simulator.netty.NettyTCPReceiver;
import code.simulator.netty.NettyTCPSender;
import code.untrustedstorage.writeanyreadany.StorageConfig;

public class NetworkHandler{
  NettyTCPReceiver receiver;
  NettyTCPSender sender;
  IrisNetworkQueue inq;
  
  public NetworkHandler(long myId, IrisNetworkQueue inq){
    assert(StorageConfig.useNetty);
    this.inq = inq; // make appropriate modifications here to add the Client/Server node
    receiver = new NettyTCPReceiver(Config.getDNS(new NodeId(myId)), (int)(StorageConfig.NettyTCPListenPort+myId), inq, StorageConfig.NumNettyReceiveThreads);
    sender = new NettyTCPSender(StorageConfig.NumNettySendThreads);
  }
  
  public void send(long id, IrisSerializable is, boolean optimized) throws IOException{
    ByteArrayOutputStream bs = new ByteArrayOutputStream(1000);
    IrisOutputStream ios = new IrisOutputStream(bs);
    is.writeToStream(ios, optimized);
    ios.flush();
    this.send(id, bs.toByteArray());
  }

  public void send(long id, byte[] buf){
    sender.send(buf, Config.getDNS(new NodeId(id)), (int)(StorageConfig.NettyTCPListenPort+id));
  }
  
  public void send(long[] id, byte[] buf){
    Vector<Pair<String,  Integer>> addresses = new Vector<Pair<String, Integer>>();
    for(int i = 0; i < id.length; i++){
      addresses.add(new Pair<String, Integer>(Config.getDNS(new NodeId(id[i])), (int)(StorageConfig.NettyTCPListenPort+id[i])));
    }
    sender.send(buf, addresses);
  }

  public void close(){
    receiver.close();
    sender.close();
  }
}
