package code.simulator.log;

import code.PreciseInv;

public class LogEntry implements Comparable{

  private PreciseInv pi;
  
  public LogEntry(PreciseInv pi){
    assert pi!=null;
    this.pi = pi;
  }
  
  public int compareTo(Object o) throws ClassCastException{
    if(!(o instanceof LogEntry)){
      throw new ClassCastException();
    }else{
      return pi.getAcceptStamp().compareTo(((LogEntry)o).pi.getAcceptStamp());
    }
  }
  
  public boolean equals(Object o){
    if(!(o instanceof LogEntry)){
      return false;
    }else{
      return pi.getAcceptStamp().equals(((LogEntry)o).pi.getAcceptStamp());
    }
  }
  
  public int hashCode(){
    return pi.getAcceptStamp().hashCode();
  }
  
  public PreciseInv getInv(){
    return pi;
  }
}
