package code.simulator.log;
import java.util.*;
import java.util.Map.Entry;

import code.PreciseInv;
import code.branchDetecting.BranchID;
import code.branchDetecting.HashTSTuple;
import code.simulator.SecureSimPreciseInv;
import code.simulator.SimPreciseInv;
import code.simulator.agreement.Tuple;
import code.CounterVV;
import code.AcceptVV;
import code.VV;

public class NodeLog implements List<PreciseInv>{//extends ArrayList<PreciseInv>{

  private ArrayList<Long> asList;
  private ArrayList<PreciseInv> piList;
  CounterVV dependencyVV;
  
 // public static ASComparator asComparator = new ASComparator();
  public NodeLog(){
    asList = new ArrayList<Long>();
    piList = new ArrayList<PreciseInv>();
    dependencyVV = new CounterVV();

    // TODO Auto-generated constructor stub
  }

  public NodeLog(Collection<PreciseInv> c){
    asList = new ArrayList<Long>();
    piList = new ArrayList<PreciseInv>();
    dependencyVV = new CounterVV();
    
    Collections.sort(this);
    for(PreciseInv pi: this){
      asList.add(pi.getAcceptStamp().getLocalClock());
      SecureSimPreciseInv spi = (SecureSimPreciseInv)pi;
      dependencyVV.addMinVV(spi.getDVV());
    }
    
    // TODO Auto-generated constructor stub
  }
  
  /**
   * 
   * @param as
   * @return the PreciseInv having the given timestamp or the smaller element
   */
  public Entry<Boolean, Integer> binarySearch(Long as){
    int index = Collections.binarySearch(asList, as);
    if(index >= 0){
      return new Tuple<Boolean, Integer>(true, index);
    }else{
      index = (-index)-1; // the next largest element position
      assert index <= asList.size();
      return new Tuple<Boolean, Integer>(false, index-1);
    }
  }
  
  public void advanceDependencyVV(VV vv){
    this.dependencyVV.addMaxVV(vv);
  }
  
  public AcceptVV getDepedencyVV(){
    return new AcceptVV(dependencyVV);
  }
//  /**
//   * 
//   * @param as
//   * @return the PreciseInv having the given timestamp or the smaller element
//   */
//  public PreciseInv binarySearchInval(Long as){
//    return get(binarySearch(as));
//  }

  public boolean add(PreciseInv o){
    // TODO Auto-generated method stub
    boolean ret = piList.add(o);
    if(asList.size() > 0){
      assert (asList.get(asList.size()-1) < o.getAcceptStamp().getLocalClock()): "\n"+asList.get(asList.size()-1) + "\n" + o;
    }
    asList.add(o.getAcceptStamp().getLocalClock());
    SimPreciseInv spi = (SimPreciseInv)o;
    dependencyVV.addMaxVV(spi.getDVV());
    return ret;
  }

  public void add(int index, PreciseInv element){
    assert false;
    // TODO Auto-generated method stub
    assert false;
  }

  public boolean addAll(Collection<? extends PreciseInv> c){
    // TODO Auto-generated method stub
    assert false;
    return false;
  }

  public boolean addAll(int index, Collection<? extends PreciseInv> c){
    // TODO Auto-generated method stub
    assert false;
    return false;
  }

  public void clear(){
    // TODO Auto-generated method stub
    asList.clear();
    piList.clear();
    dependencyVV.reset();
  }

  public boolean contains(Object o){
    return piList.contains(o);
  }

  public boolean containsAll(Collection<?> c){
    return piList.containsAll(c);
  }

  public PreciseInv get(int index){
    return piList.get(index);
  }

  public int indexOf(Object o){
    assert false;
    return -1;
  }

  public boolean isEmpty(){
    return piList.isEmpty();
  }

  public Iterator<PreciseInv> iterator(){
    return piList.iterator();
  }

  public int lastIndexOf(Object o){
    assert false;
    return -1;
  }

  public ListIterator<PreciseInv> listIterator(){
    // TODO Auto-generated method stub
    return null;
  }

  public ListIterator<PreciseInv> listIterator(int index){
    return piList.listIterator(index);
  }

  public boolean remove(Object o){
    assert false;
    // TODO Auto-generated method stub
    return false;
  }

  public PreciseInv remove(int index){
    asList.remove(index);
    PreciseInv pi = piList.remove(index);
    System.err.println("removing writes from log is dangerous \n");
    return pi;
  }

  public boolean removeAll(Collection<?> c){
    assert false;
    // TODO Auto-generated method stub
    return false;
  }

  public boolean retainAll(Collection<?> c){
    assert false;
    // TODO Auto-generated method stub
    return false;
  }

  public PreciseInv set(int index, PreciseInv element){
    assert false;
    // TODO Auto-generated method stub
    return null;
  }

  public int size(){
    return piList.size();
  }

  public List<PreciseInv> subList(int fromIndex, int toIndex){
    assert false;
    // TODO Auto-generated method stub
    return null;
  }

  public Object[] toArray(){
    return piList.toArray();
  }

  public <T> T[] toArray(T[] a){
    assert false;
    // TODO Auto-generated method stub
    return null;
  }
  
  public String toString(){
    return asList.toString();
  }

  public CounterVV getDependencyVV(){
    return dependencyVV;
  }

  public void setDependencyVV(CounterVV dependencyVV){
    this.dependencyVV = dependencyVV;
  }

  /**
   * retain writes till stampByServer (including)
   * @param stampByServer
   */
  public void reset(long stampByServer){
    long lastTS = asList.get(asList.size()-1);
    assert lastTS >= stampByServer: lastTS + " StampByServer"  + stampByServer;
    if(lastTS == stampByServer){
      return;
    }
    dependencyVV = new CounterVV();
    asList.clear();
    List<PreciseInv> newPiList =  this.piList; 
    piList = new ArrayList<PreciseInv>();
    for(PreciseInv pi: newPiList){
      if(pi.getAcceptStamp().getLocalClock() <= stampByServer){
        this.add(pi);
      }
    }
    assert asList.get(asList.size()-1) == stampByServer;
  }
  

//  class ASComparator implements Comparator{
//
//    public int compare(Object o1, Object o2){
//      
//      Long a1, a2;
//
//      if(o1 instanceof PreciseInv){
//        a1 = ((PreciseInv)o1).getLong();
//      }else if (o1 instanceof Long){
//        a1 = (Long)o1;
//      }else{
//        a1 = null;
//        assert false;
//      }
//      
//      if(o2 instanceof PreciseInv){
//        a2 = ((PreciseInv)o2).getLong();
//      }else if (o2 instanceof Long){
//        a2 = (Long)o2;
//      }else{
//        a2 = null;
//        assert false;
//      }
//      
//      // TODO Auto-generated method stub
//      return (a1.compareTo(a2));
//    }
//    
//  }
}
