/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package code.simulator.netty;

import java.io.IOException;
import java.net.*;
import java.nio.*;
import java.nio.channels.*;
import java.util.*;

import java.util.concurrent.Executors;
import java.net.InetSocketAddress;

import java.util.concurrent.ConcurrentHashMap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

/**
 *
 * @author manos
 */
public class NettyTCPReceiver {
    
    // The channel on which we'll accept connections
    private ServerBootstrap bootstrap;
    org.jboss.netty.channel.Channel channel;
    
    public NettyTCPReceiver(String hostname, int port, NetworkQueue NQ){
        this(hostname, port, NQ, 1);
    }
    
    public NettyTCPReceiver(String hostname, int port, NetworkQueue NQ, int threadCount){

	// create a bootstrap object that builds up the basic chain
        bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(
	          Executors.newCachedThreadPool(),
	          Executors.newCachedThreadPool(),
	          threadCount));


        bootstrap.setOption("child.tcpNoDelay", true);
        bootstrap.setOption("child.keepAlive", true);
	bootstrap.setPipelineFactory(new BFTPipelineFactory(NQ));

        try {
            InetSocketAddress isa = new InetSocketAddress(InetAddress.getByName(hostname), port);
            System.err.println("Opening to localhost "+port);
            channel = bootstrap.bind(isa);
        } catch (UnknownHostException ex) {
            System.out.println("failed (2) on establihsing a server channel on port "+port);
            ex.printStackTrace();
        } catch (IOException ioe) {
            System.out.println("failed on establishing server channel on port "+port);
            ioe.printStackTrace();
        }
    }
    
    /**
     * code based on description at http://docs.jboss.org/netty/3.1/guide/html_single/#d0e1529
     */
    public void close(){
      channel.close();
//      bootstrap.releaseExternalResources();
    }
}
