/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package code.simulator.netty;

import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.Executors;

import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import static org.jboss.netty.buffer.ChannelBuffers.*;

/**
 * @author manos
 */
public class NettyTCPSender {
  private Hashtable<String, NettyFutureListener> socketTable;
  ClientBootstrap clientBootstrap;
  ChannelFuture future;
  
  public NettyTCPSender(int threadCount) {
    
    //this.membership = members;
    clientBootstrap = new ClientBootstrap(
        new NioClientSocketChannelFactory(
            Executors.newCachedThreadPool(),
            Executors.newCachedThreadPool(), threadCount));

    clientBootstrap.setOption("tcpNoDelay", true);
    clientBootstrap.setOption("keepAlive", true);

    PassThroughNetworkQueue dnq = new PassThroughNetworkQueue();
    clientBootstrap.setPipelineFactory(new BFTPipelineFactory(dnq));

    socketTable = new Hashtable<String, NettyFutureListener>(40);
    //        socketTable = new Hashtable<String, NettyFutureListener>();

  }

  public void send(byte[] m, String dns, int port){
    sendHelper(createAllBytes(m), dns, port);
  }

  public static byte[] createAllBytes(byte[] m){
    byte[] lenBytes = UnsignedTypes.longToBytes((long) m.length);
    byte[] allBytes = new byte[m.length + 8]; // MARKER change
    // TLR 2009.1.23: Changed marker to be length of message
    ////System.err.println("\tsending "+m.length+" bytes");
    System.arraycopy(lenBytes, 0, allBytes, 0, 4);
    System.arraycopy(m, 0, allBytes, 4, m.length);
    System.arraycopy(lenBytes, 0, allBytes, m.length + 4, 4);
    return allBytes;
  }

  public void send(byte[] m, Vector<Pair<String, Integer>> address){
    byte[] allBytes = createAllBytes(m);

    for(Pair<String,Integer> add: address){
      sendHelper(allBytes, add.getLeft(), add.getRight());
    }

  }

  synchronized private void sendHelper(byte[] allBytes, String dns, int port){
    String key = dns +"."+String.valueOf(port);
    NettyFutureListener nfl = null;
    nfl = socketTable.get(key);
    if(nfl == null) {
      nfl = new NettyFutureListener();
      socketTable.put(key, nfl);
    }

    Channel channel = nfl.getChannel();
    //System.out.println(socketName+" "+channel);

    if (channel == null || !channel.isOpen()) {

      System.out.println("Will try to connect to host " + dns + " and port " + port);

      nfl.addMessage(allBytes);

      future = clientBootstrap.connect(new InetSocketAddress(dns, port));
      future.addListener(nfl);

    } else {
      ChannelBuffer buf = copiedBuffer(allBytes);
      ChannelFuture lastWriteFuture = channel.write(buf);
    }
  }

  /**
   * code based on description at http://docs.jboss.org/netty/3.1/guide/html_single/#d0e1529
   */
  synchronized public void close(){
//    future.getChannel().getCloseFuture().awaitUninterruptibly();
//    clientBootstrap.releaseExternalResources();
  }

}
