// Copyright (C) 2008 Taylor L. Riche <riche@cs.utexas.edu>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// $Id: Pair.java 49 2010-02-26 19:33:49Z yangwang $
//

package code.simulator.netty;

public class Pair<L, R> {

	private final L left;
	private final R right;

	public R getRight() {
		return right;
	}

	public L getLeft() {
		return left;
	}

	public Pair(final L left, final R right) {
		this.left = left;
		this.right = right;
	}

	public static <A, B> Pair<A, B> create(A left, B right) {
		return new Pair<A, B>(left, right);
	}

	public final boolean equals(Object o) {
		if (!(o instanceof Pair))
			return false;

		final Pair<?, ?> other = (Pair<?,?>) o;
		return equal(getLeft(), other.getLeft()) && equal(getRight(), other.getRight());
	}

	public static final boolean equal(Object o1, Object o2) {
		if (o1 == null) {
			return o2 == null;
		}
		return o1.equals(o2);
	}

	public int hashCode() {
		int hLeft = getLeft() == null ? 0 : getLeft().hashCode();
		int hRight = getRight() == null ? 0 : getRight().hashCode();

		return hLeft + (57 * hRight);
	}
}
