package code.simulator.notification;

import java.util.Collection;

import code.ObjId;
import code.simulator.NamespaceWatch;
import code.simulator.store.StoreEntry;

public class Notification{

  public static final byte SubscriptionNotification = 0x00;
  public static final byte Checkpoint = 0x00;
  public static final byte Write = 0x01;
  
  private final NamespaceWatch namespaceWatch;
  private final byte type;
  private final StoreEntry se;
  private final int epoch;
  private final ObjId oid;

  
  public Notification(NamespaceWatch nw, StoreEntry se, ObjId o, int epoch){
    this.namespaceWatch = nw;
    this.type = Write;
    this.se = se;
    this.oid = o;
    this.epoch = epoch;
  }
  
  public Notification(NamespaceWatch nw, int epoch){
    this.namespaceWatch = nw;
    this.type = Checkpoint;
    se = null;
    oid = null;
    this.epoch = epoch;
  }
  
  public NamespaceWatch getWatch(){
    return namespaceWatch;
  }
  
  public byte getNotificationType(){
    return type;
  }
  
  public ObjId getObjId(){
    return oid;
  }
  
  public StoreEntry getStoreEntry(){
    return se;
  }
  
  public int getEpoch(){
    return epoch;
  }

}
