package code.simulator.notification;

import java.util.ArrayList;
import java.util.LinkedList;

public class NotificationQueue {
  private static long head_counter = 0;
  private LinkedList queue;
  private final static boolean debug = false;

  private static long timer_msg_cnt = 0;
  private static int QUEUE_THRESH = 65536;
  private long start  = 0;     

  public static long startTime =0;
  public static long messages = 0;

  // constructor
  public NotificationQueue ()  {
    start = System.currentTimeMillis();
    queue = new LinkedList();
  }


  synchronized public void enQueue (Object item) {
    if (startTime == 0) startTime = System.currentTimeMillis();
    messages++;

    queue.addLast(item);
    if (debug ) {System.out.println("ENQUEUE*** "+ this.hashCode()+" ***********"+queue.size()+"*********");}

    this.notifyAll();
  }

  synchronized public int getSize() {
    return queue.size();
  }

  synchronized public Object deQueue () {
    Object obj = null;

    while(queue.isEmpty())
    {
      try {
        this.wait();
      } catch (InterruptedException e) {
        // do nothing
      }
    }

    obj = queue.removeFirst();
    if (debug) {System.out.println("DEQUEUE*** "+this.hashCode()+" ***********"+queue.size()+"*********");}


    this.notifyAll();
    return obj;
  }

  synchronized public boolean isEmpty() {
    return queue.isEmpty();
  }

  synchronized public void printQueue() {
    System.out.println(queue.toString());
  }

  // test it out
  public static void main(String args[]) {
    NotificationQueue myQueue = new NotificationQueue();
    myQueue.enQueue("hello");
    myQueue.enQueue("there");
    myQueue.enQueue("SIMIANS");
    assert myQueue.deQueue().equals("hello");
    assert myQueue.deQueue().equals("there");
    myQueue.enQueue("are");
    myQueue.enQueue("awesome!");
    assert myQueue.deQueue().equals("SIMIANS");
    assert myQueue.deQueue().equals("are");
    assert myQueue.deQueue().equals("awesome!");
    assert myQueue.isEmpty();
  }

}

