package code.simulator.notification;


public class NotificationThread extends Thread{

  NotificationQueue queue;
  public NotificationThread(NotificationQueue queue){
    super("NotificationThread");
    this.queue = queue;
    setDaemon(true);
    this.start();
  }

  @Override
  public void run(){
    while(true){
      Object o = queue.deQueue();
      assert o instanceof Notification;
      processNotification((Notification)o);
    }
  }
  
  void processNotification(Notification n){
    switch(n.getNotificationType()){
    case Notification.Checkpoint: n.getWatch().notifyCheckpoint(n.getEpoch());
    break;
    case Notification.Write: n.getWatch().notifyWrite(n.getEpoch(), n.getObjId(), n.getStoreEntry());
    break;
    default:assert false;
    }
  }
  
}
