package code.simulator.notification.unit;

import code.branchDetecting.BranchID;
import code.simulator.*;
import code.simulator.SyncRequest;
import code.simulator.agreement.Tuple;
import code.simulator.checkpoint.unit.SimulatorCheckpointUnit;
import code.simulator.store.StoreEntry;
import code.simulator.unit.SimulatorUnit;
import code.*;
import code.security.SangminConfig;

 /** 
 *  Test bandwidth to subscribe to 1000 objects, 100 of which have
 
 *  been modified. Test created for sosp 2007 submission microbenchmark.
 
 **/ 

//package utils.junit;

import junit.textui.TestRunner;
import junit.framework.*;
import java.util.*;
import java.io.*;

/**
 * TBD: Update class name
 */
public class NotificationUnit extends TestCase {
  public static final String TEST_ALL_TEST_TYPE = "UNIT";
  
  /**
   * Basic constructor - called by the test runners.
   * TBD: Update constructor name to match class
   */
  public NotificationUnit (final String s) {
    super (s);
  }

  /*
   * Fixtures are run before and after each test case
   * to set up environment in which tests must run.
   */
  protected void setUp() throws Exception{
    super.setUp();
    SimulatorCheckpointUnit.makePractiConfig(0, 100);
 
  }


  public static int UNIT_NODE_ID = 10;
  public static int MIDDLE_NODE_ID = 15;

  public static int HELPER_NODE_ID = 20;
  public static boolean vverbose = false;
  public static boolean verbose = true;


  public static String COARSE_PATH = "/coarse";


  //--------------------------------------------------------------------------- 
  // Test coarse-grained subscriptions. 
  //
  // To initialize state, Unit create 1000 objects
  // (/data-coarse/[0..9]/[0..9]/[0..9]. Then helper subscribe
  // to /* from unit and wait for /data-coarse/9/9/9 to arrive.
  //
  //
  // start helper and wait for writing to complete
  //---------------------------------------------------------------------------
  public void testSimple(){
    try{
      System.out.println("testSimple");

      BranchID myNodeId = NodeFactory.createNodeId(UNIT_NODE_ID);

      BranchID helperNodeId = NodeFactory.createNodeId(HELPER_NODE_ID);
      if(vverbose){
        System.out.println("UNIT ID: " + myNodeId.toString());
      }
      assert(myNodeId.equals(NodeFactory.createNodeId(UNIT_NODE_ID)));
  
      IrisNode myNode = (IrisNode)NodeFactory.createNodeWithoutFilter(myNodeId);
      IrisNode helperNode = (IrisNode)NodeFactory.createNodeWithoutFilter(helperNodeId);

      TestWatch tw1 = new TestWatch();
      TestWatch tw2 = new TestWatch();
      TestWatch tw3 = new TestWatch();
      
      SubscriptionSet ss2 = SubscriptionSet.makeSubscriptionSet(COARSE_PATH+"/test/*");
      SubscriptionSet ss1 = SubscriptionSet.makeSubscriptionSet(COARSE_PATH+"/*");
      SubscriptionSet ss3 = SubscriptionSet.makeSubscriptionSet(COARSE_PATH+"/*");
      
      myNode.addNamespaceWatch(tw1, ss1);
      helperNode.addNamespaceWatch(tw2, ss2);
      helperNode.addNamespaceWatch(tw3, ss3);
      //second set of writes
      
      if(verbose){
        System.out.println("Hello from SimulatorUnit");
      }

      assert myNode.getCurrentVV().equalsIgnoreNegatives(new AcceptVV());

      int ni = 5;
      int startVal = 0;
      for(int ii = 0; ii < ni; ii++){
        AcceptStamp as = new AcceptStamp(ii, myNode.getBranchID());
        ObjId oid = new ObjId(COARSE_PATH + "/" + ii );
        StoreEntry se = new StoreEntry(new IrisDataObject(new Integer(startVal+ii)), as, Hash.NullHash, false);
        Tuple<ObjId, StoreEntry> tuple = new Tuple<ObjId, StoreEntry>(oid, se); 
        tw1.addNotifications(tuple);
        tw3.addNotifications(tuple);
        SimPreciseInv pi = myNode.write(oid, new IrisDataObject(new Integer(startVal + ii)));
        assert new StoreEntry(pi).getData().getHash().equals(se.getData().getHash());
        assert new StoreEntry(pi).getAcceptStamp().equals(se.getAcceptStamp());
        assert pi.getAcceptStamp().eq(as);
//        assert tw1.getNumNotifications() == (ii+1):tw1.getNumNotifications() + " ii=" +(ii+1);
      }
//      assert tw1.getNumNotifications() == ni: tw1.getNumNotifications();
      assert tw3.getNumNotifications() == 0;
      
      checkRead(myNode, COARSE_PATH, 0, ni-1, 0);
      SyncRequest sr = new SyncRequest(new AcceptVV(), 0, new HashSet<ProofOfMisbehavior> (), myNode.getBranchID().getIDint(), SangminConfig.BodyConfig, false);
      SyncPacket sp = ((IrisNode)myNode).getSyncPacket(sr);
      SyncStatus ss = ((IrisNode)myNode).applySyncPacket(sp);
      System.out.println(ss);
      assert ss.status == SyncStatus.SyncSuccessful;
      
      assert myNode.getCurrentVV().includes(new AcceptStamp(ni-1, myNodeId));
      assert !myNode.getCurrentVV().includes(new AcceptStamp(ni, myNodeId));

      helperNode.sync(myNode);
//      assert tw3.getNumNotifications() == ni:tw3.getNumNotifications();
      assert tw2.getNumNotifications() == 0;

      checkRead(helperNode, COARSE_PATH, 0, ni-1, 0);
      
      // now do writes at helper node and sync with the main node
      
      startVal = 10;
      for(int ii = 0; ii < ni; ii++){
        AcceptStamp as = new AcceptStamp(ni+ii, helperNode.getBranchID());
        ObjId oid = new ObjId(COARSE_PATH + "/test/" + ii );
        StoreEntry se = new StoreEntry(new IrisDataObject(new Integer(startVal+ii)), as, Hash.NullHash, false);
        Tuple<ObjId, StoreEntry> tuple = new Tuple<ObjId, StoreEntry>(oid, se); 
        tw1.addNotifications(tuple);
        tw2.addNotifications(tuple);
        tw3.addNotifications(tuple);
        SimPreciseInv pi = helperNode.write(oid, new IrisDataObject(new Integer(startVal + ii)));
        assert new StoreEntry(pi).getAcceptStamp().equals(se.getAcceptStamp());
        assert new StoreEntry(pi).getData().getHash().equals(se.getData().getHash());
        assert pi.getAcceptStamp().eq(as);
//        assert tw2.getNumNotifications() == (ii+1):tw2.getNumNotifications() + " ii=" +(ii+1);
//        assert tw3.getNumNotifications() == (ii+1+ni):tw3.getNumNotifications() + " ii=" +(ii+1+ni);

      }
      checkRead(helperNode, COARSE_PATH+"/test", 0, ni-1, 10);

      assert helperNode.getCurrentVV().includes(new AcceptStamp(ni-1+5, helperNodeId));
      assert !helperNode.getCurrentVV().includes(new AcceptStamp(ni+5, helperNodeId));

      myNode.sync(helperNode);
//      assert tw1.getNumNotifications() == (ni+ni);
//      assert tw2.getNumNotifications() == ni;
//      assert tw3.getNumNotifications() == (ni+ni);
    }catch(Exception e){
      e.printStackTrace();
      assert false;
    }
    
  }
    
  public static void checkRead(Node n, 
      String prefix, 
      int is, int ie, int startVal){
      int ii;

    if(vverbose){
      System.out.println("Reading initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Reading " + oid);
      }
      IrisObject io = SimulatorUnit.resolveConflict(n.rawRead(oid));
      assert ((IrisDataObject)io).getObject().equals(startVal + ii): "Expected value for obj " + oid + " was " + (startVal + ii) + " instead found " + n.read(oid);
    }
  }

  public static void printRead(Node n, 
      String prefix, 
      int is, int ie){
      int ii;

    if(vverbose){
      System.out.println("Reading initial data: " + is + " to " + ie + " etc.");
    }
    for(ii = is; ii <= ie; ii++){

      ObjId oid = new ObjId(prefix + "/" + ii );
      if(vverbose){
        System.out.println("Reading " + oid);
      }
      Object o = n.read(oid);
      if(o != null){
        System.out.println("at node " + n + " Object " + oid + " has value " + o);
      }
    }
  }
  
 /** 
 *  Write -- write 1-byte items to /prefix/[is..ie]/[js..je]/[ks..ke].
 
 *  Return final accept stamp.
 
 **/ 
  public static AcceptStamp write(Node n, 
                           String prefix, 
                           int is, int ie, 
                           int startVal){
    int ii;

    AcceptStamp as = null;
    if(vverbose){
      System.out.println("Writing initial data: " + is + " to " + ie + " etc.");
    }
    
    return as;
  }
    

  /*
   * "new TestSuite(Class c)" constructs a test suite
   * containg every method whose name begins with "test"
   * 
   * TBD: update class name
   */
  public static Test suite(){
    TestSuite suite = new TestSuite(NotificationUnit.class);
    return suite;
  }


  /*
   * main() lets us run just this set of unit tests
   * from the comand line (you can also invoke 
   * the testrunner on this class and it will find
   * the suite())
   *
   * usage: java <classname> [-verbose] [-vverbose] [testName]*
   * 
   *   If verbose or vverbose are included, print info to screen
   *
   *   If [testName]* are included, then run test called "test[testName]"
   *   for each such [testName]. E.g., "java TestEmtpy foo" runs
   *   TwoNodesSubscriptionUnit.testfoo() as a TestCase.
   *
   * TBD: update class name
   */
  public static void main(String s[]) {
    String name = "NotificationUnit";
    System.err.print(name + " self test begins...");
    Test test;
    test = suite();
    TestRunner tr = new TestRunner();
    tr.doRun(test);
    System.exit(0);
  }

}



