package code.simulator.notification.unit;

import java.util.LinkedList;

import code.ObjId;
import code.simulator.NamespaceWatch;
import code.simulator.agreement.Tuple;
import code.simulator.store.StoreEntry;

public class TestWatch implements NamespaceWatch{

  final private LinkedList<Tuple<ObjId, StoreEntry>> notifications;
  private int numNotifications = 0;
  public TestWatch(){
    this.notifications = new LinkedList<Tuple<ObjId, StoreEntry>>(); 
   }
  
  public TestWatch(LinkedList<Tuple<ObjId, StoreEntry>> notifications){
   this.notifications = notifications; 
  }
  public void notifyCheckpoint(int epoch){
    // TODO Auto-generated method stub
    assert false;
  }

  synchronized public void notifyWrite(int epoch, ObjId o, StoreEntry se){
    // TODO Auto-generated method stub
    assert !notifications.isEmpty();
    Tuple<ObjId, StoreEntry> t = notifications.removeFirst();
    assert t.getKey().equals(o): o + " " + t;
    assert t.getValue().getData().equals(se.getData()): "\n"+se + "\n" + t;
    assert t.getValue().getAcceptStamp().equals(se.getAcceptStamp()): "\n"+se + "\n" + t;
    numNotifications++;
  }
  synchronized public void addNotifications(Tuple<ObjId, StoreEntry> tuple){
    notifications.add(tuple);
  }

  synchronized public int getNumNotifications(){
    return numNotifications;
  }

}
