package code.simulator.protocolFilters;

import java.util.Collection;
import java.util.TreeSet;
import java.util.HashSet;
import java.util.LinkedList;

import code.AcceptVV;
import code.branchDetecting.*;
import code.simulator.Certificate;
import code.simulator.IrisNode;
import code.simulator.SimPreciseInv;
import code.simulator.agreement.Tuple;
import code.simulator.store.StoreEntry;
import code.ObjId;
import code.VVIterator;
import code.NodeId;

public class BWSyncFilter implements SyncFilter{
  public static int hashSize = 20;
  public static int signatureSize = 0;
  public static int branchIDSize = 20;
  public static int timestampSize = 8;
  public static int numNodeSize = 2;
  long metadataCost = 0;
  long cost = 0;

  public void notifyEpochSync(IrisNode myNode, Certificate certs){
    // find the cost of all epochAdvancing writes at the other node
    
//    for(Certificate c: certs){
//      if(lastCheckpoint != null && !myOmitVV.equals(lastCheckpoint.omitVV)){
//        if(!myCVV.includes(lastCheckpoint.endVV)){
//  
//          if(!myCVV.includes(lastCheckpoint.omitVV)){
//            // add the cost for objectStore
//            // add the cost for lastWrites
//            cost += lastCheckpoint.omitVV.getDiff(myCVV).dropNegatives().size()*(hashSize);
//          }
//  
//          myCVV = myCVV.cloneMaxVV(lastCheckpoint.omitVV);
//        }
//        // cost for checkpoint attestation
//  
//      }
//    }
  }

  public void syncOver(IrisNode myNode, boolean success){
    metadataCost = 0;
    cost = 0; 
  }
  
  public boolean notifySync(IrisNode myNode, AcceptVV myCVV, BranchID otherNodeId, 
//      AcceptVV otherCVV,
//      Checkpoint lastCheckpoint, 
      TreeSet<SimPreciseInv> newUpdates
//      , AcceptVV myOmitVV
      , Collection<Tuple<ObjId, TreeSet<StoreEntry>>> addedEntries
      ){
    if(IrisNode.printStats){

      metadataCost += myCVV.dropNegatives().getSize()*(branchIDSize+timestampSize*hashSize);

//      VVIterator vvi = otherCVV.getIterator();
//      while(vvi.hasMoreElements()){
//        NodeId n = vvi.getNext();
//        if(!myCVV.containsNodeId(n) && ((BranchID)n).isForked()){
//          metadataCost += timestampSize;
//        }
//      }
//
//      if(myCVV.includes(otherCVV)){
//        cost += 1; // for EOF
//      }else{
        

        HashSet<BranchID> uniqueBranchID = new HashSet<BranchID>();
        int numFaultyWrites = 0;
        for(SimPreciseInv spi: newUpdates){
          if(!uniqueBranchID.contains(spi.getNodeId())){
            uniqueBranchID.add((BranchID)spi.getNodeId());
          }
          cost += timestampSize + (spi.getDVV().getSize()>0?spi.getDVV().getSize()-1:0)*timestampSize + numNodeSize;
          if(((BranchID)spi.getNodeId()).isForked()){
            numFaultyWrites++;
          }
        }
        System.out.println("FAULTY UPDATE: nodeid " + myNode.getBranchID() + " numFaultyWrites: " + numFaultyWrites);

        cost += uniqueBranchID.size()*(branchIDSize + hashSize + signatureSize);

        cost += metadataCost;

//      }

      System.out.println("BW: nodeid " + myNode.getBranchID() + " MetadataCost: " + metadataCost + " TotalCost: " + cost);
    }
    return true;
  }

}
