package code.simulator.protocolFilters;

import java.util.HashMap;
import java.util.TreeSet;

import code.branchDetecting.*;
import code.simulator.Certificate;
import code.NodeId;
import code.PreciseInv;

public class EvictionCertificate extends Certificate{
  final NodeId nodeId;
  private final HashMap<BranchID, TreeSet<PreciseInv>> forkedWrites;
  final int epochCount;
  
  public EvictionCertificate(NodeId n,  HashMap<BranchID, TreeSet<PreciseInv>> forkedWrites, int epoch){
    this.forkedWrites = forkedWrites;
    this.nodeId = n;
    this.epochCount = epoch;
  }
  
  public boolean verify(){
    return true;
  }
  
  public int getEpoch(){
    return epochCount;
  }
  
  public NodeId getNodeId(){
    return nodeId;
  }
  
  public boolean equals(Object o){
    if(!(o instanceof EvictionCertificate)){
      return false;
    }else{
      EvictionCertificate ec = (EvictionCertificate)o;
      return nodeId.equals(ec.nodeId) && epochCount == ec.epochCount;
    }
  }

  public HashMap<BranchID, TreeSet<PreciseInv>> getForkedWrites(){
    return forkedWrites;
  }
}
