package code.simulator.protocolFilters;

import java.util.HashMap;
import java.util.TreeSet;

import code.branchDetecting.*;
import code.simulator.ProofOfMisbehavior;
import code.NodeId;
import code.PreciseInv;

public class EvictionProposal implements Comparable, Proposal{
  ProofOfMisbehavior pom;
  NodeId bid;
  HashMap<BranchID, TreeSet<PreciseInv>> forkedWrites;
  
  public EvictionProposal(HashMap<BranchID, TreeSet<PreciseInv>> forkedWrites, ProofOfMisbehavior pom, NodeId bid){
    this.forkedWrites = forkedWrites;
    this.bid = bid;
    this.pom = pom;
  }
  
  // define equals and compareTO
  
  public boolean equals(Object o){
    if(!(o instanceof EvictionProposal)){
      return false;
    }else{
      EvictionProposal ep = (EvictionProposal)o;
      if(bid.equals(ep.bid)){
        assert pom.equals(ep.pom) && forkedWrites.equals(ep.forkedWrites);
        return true;
      }
      return false;
    }
  }
  
  public int hashCode(){
    return bid.hashCode();
  }
  
  public int compareTo(Object o) throws ClassCastException{
    if(!(o instanceof EvictionProposal)){
      throw new ClassCastException(o + " not instanceof EvictionProposal");
    }else{
      EvictionProposal ep = (EvictionProposal)o;
      if(bid.gt(ep.bid)){
        return 1;
      }else if(bid.lt(ep.bid)){
        return -1;
      }else{
        return 0;
      }
    }
  }

}
