package code.simulator.protocolFilters;

import code.simulator.Certificate;
import code.simulator.HashedVV;
import code.simulator.checkpoint.Checkpoint;

public class GCCertificate extends Certificate{

  final Checkpoint checkpoint;
  final HashedVV omitVV;
  final HashedVV endVV;
  
  public GCCertificate(Checkpoint chkPt){
    this.checkpoint = chkPt;
    omitVV = null;
    endVV = null;
  }
  
  public GCCertificate(Checkpoint chkPt, HashedVV omitVV, HashedVV endVV){
    this.checkpoint = chkPt;
    this.omitVV = omitVV;
    this.endVV = endVV;
  }
  
  public GCCertificate(HashedVV omitVV, HashedVV endVV){
    this.checkpoint = null;
    this.omitVV = omitVV;
    this.endVV = endVV;
  }
  
  
  public boolean verify(){
    // TODO Auto-generated method stub
    return true;
  }
  
  public Checkpoint getCheckpoint(){
    return checkpoint;
  }

  public int getEpoch(){
    return checkpoint.epochCount;
  }

  public HashedVV getOmitVV(){
    if(omitVV == null){
      return (HashedVV)checkpoint.omitVV;
    }
    return omitVV;
  }

  public HashedVV getEndVV(){
    if(endVV == null){
      return (HashedVV)checkpoint.endVV;
    }
    return endVV;
  }

  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result
        + ((checkpoint == null) ? 0 : checkpoint.hashCode());
    result = prime * result + ((endVV == null) ? 0 : endVV.hashCode());
    result = prime * result + ((omitVV == null) ? 0 : omitVV.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof GCCertificate)){
      return false;
    }
    GCCertificate other = (GCCertificate) obj;
    if(checkpoint == null){
      if(other.checkpoint != null){
        return false;
      }
    }else if(!checkpoint.equals(other.checkpoint)){
      return false;
    }
    if(endVV == null){
      if(other.endVV != null){
        return false;
      }
    }else if(!endVV.equals(other.endVV)){
      return false;
    }
    if(omitVV == null){
      if(other.omitVV != null){
        return false;
      }
    }else if(!omitVV.equals(other.omitVV)){
      return false;
    }
    return true;
  }
  
  
}
