/**
 * 
 */
package code.simulator.protocolFilters;

import java.util.*;

import code.AcceptVV;
import code.ObjId;
import code.branchDetecting.BranchID;
import code.simulator.Certificate;
import code.simulator.IrisDataObject;
import code.simulator.IrisNode;
import code.simulator.SimPreciseInv;
import code.simulator.agreement.Tuple;
import code.simulator.checkpoint.Checkpoint;
import code.simulator.store.StoreEntry;

/**
 * @author princem
 * This class provides the implementation of the algorithm for distributing and collecting gc certificates. 
 * The certificates are written at pre-specified objects/filenames 
 * This class enforces the following features:
 *      - we create an gc proposal on receiving the first POM
 *      - we force nodes to create gc proposal by refusing to accept writes from other nodes in the same epoch
 *      - we invoke consensus to convert gc proposals into gc certificate
 *      - we discard gc proposals on collecting gc certificate 
 */
public interface GCProtocol extends SyncFilter{
  public void startGC(IrisNode myNode, AcceptVV avv, int epoch) throws Exception;
  
}
