package code.simulator.protocolFilters;

import code.simulator.Certificate;
import code.simulator.HashedVV;
import code.simulator.checkpoint.Checkpoint;

public class LadderedGCCertificate extends Certificate{

  final Checkpoint checkpoint;
  transient boolean hasProof;
  
  public LadderedGCCertificate(Checkpoint chkPt){
    this.checkpoint = chkPt;
    hasProof = false;
  }
  
  public void addProof(){
    hasProof = true;
  }
  
  public boolean hasProof(){
    return hasProof; 
  }
  public boolean verify(){
    return true;
  }
  
  public Checkpoint getCheckpoint(){
    return checkpoint;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result
        + ((checkpoint == null) ? 0 : checkpoint.hashCode());
    return result;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof LadderedGCCertificate)){
      return false;
    }
    LadderedGCCertificate other = (LadderedGCCertificate) obj;
    if(checkpoint == null){
      if(other.checkpoint != null){
        return false;
      }
    }else if(!checkpoint.equals(other.checkpoint)){
      return false;
    }
    return true;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString(){
    return "LadderedGCCertificate [checkpoint=" + checkpoint + "]";
  }

  @Override
  public int getEpoch(){
    return checkpoint.getEpoch();
  }

    
}
