package code.simulator.protocolFilters;

import code.AcceptVV;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Arrays;

import code.NodeId;
import code.simulator.Hash;
import code.simulator.HashedVV;

public class LadderedGCLocalCertificate implements Proposal{
  final HashedVV omitVV;
  final HashedVV endVV;
  final Hash stateHash;
  final int dayNum;
  final NodeId bid;
  
//  final HashMap<SimBranchID, TreeSet<SimPreciseInv>> unverifiableWrites;
  
  public LadderedGCLocalCertificate(HashedVV omitVV, HashedVV endVV, NodeId bid, int dayNum, Hash hash){
    this.bid = bid;
    this.omitVV  = omitVV;
    this.stateHash = hash;
    this.dayNum = dayNum;
    this.endVV = endVV;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode(){
    final int prime = 31;
    int result = 1;
    result = prime * result + ((bid == null) ? 0 : bid.hashCode());
    result = prime * result + dayNum;
    result = prime * result + ((endVV == null) ? 0 : endVV.hashCode());
    result = prime * result + ((omitVV == null) ? 0 : omitVV.hashCode());
    result = prime * result + ((stateHash == null) ? 0 : stateHash.hashCode());
    return result;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object obj){
    if(this == obj){
      return true;
    }
    if(obj == null){
      return false;
    }
    if(!(obj instanceof LadderedGCLocalCertificate)){
      return false;
    }
    LadderedGCLocalCertificate other = (LadderedGCLocalCertificate) obj;
    if(bid == null){
      if(other.bid != null){
        return false;
      }
    }else if(!bid.equals(other.bid)){
      return false;
    }
    if(dayNum != other.dayNum){
      return false;
    }
    if(endVV == null){
      if(other.endVV != null){
        return false;
      }
    }else if(!endVV.equals(other.endVV)){
      return false;
    }
    if(omitVV == null){
      if(other.omitVV != null){
        return false;
      }
    }else if(!omitVV.equals(other.omitVV)){
      return false;
    }
    if(stateHash == null){
      if(other.stateHash != null){
        return false;
      }
    }else if(!stateHash.equals(other.stateHash)){
      return false;
    }
    return true;
  }

  /* (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString(){
    return "LadderedGCProposal [bid=" + bid + ", dayNum=" + dayNum + ", endVV="
        + endVV + ", omitVV=" + omitVV + ", stateHash=" + stateHash + "]";
  }
}
